/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.data;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.jail.data.Jailing;
import io.github.nucleuspowered.nucleus.datatypes.EndTimestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@ConfigSerializable
public final class JailData
extends EndTimestamp
implements Jailing {
    @Setting
    private UUID jailer;
    @Setting
    private String jailName;
    @Setting
    private String reason;
    @Setting
    private double previousx = 0.0;
    @Setting
    private double previousy = -1.0;
    @Setting
    private double previousz = 0.0;
    @Setting
    private UUID world;
    @Setting
    private long creationTime = Instant.now().getEpochSecond();

    public JailData() {
    }

    public JailData(UUID jailer, String jailName, String reason, Location<World> previousLocation) {
        this.jailer = jailer;
        this.reason = reason;
        this.jailName = jailName;
        if (previousLocation != null) {
            this.world = ((World)previousLocation.getExtent()).getUniqueId();
            this.previousx = previousLocation.getX();
            this.previousy = previousLocation.getY();
            this.previousz = previousLocation.getZ();
        }
    }

    public JailData(UUID jailer, String jailName, String reason, Location<World> previousLocation, Instant endTimestamp) {
        this(jailer, jailName, reason, previousLocation);
        this.endtimestamp = endTimestamp.getEpochSecond();
    }

    public JailData(UUID jailer, String jailName, String reason, Location<World> previousLocation, Duration timeFromNextLogin) {
        this(jailer, jailName, reason, previousLocation);
        this.timeFromNextLogin = timeFromNextLogin.getSeconds();
    }

    public void setPreviousLocation(Location<World> previousLocation) {
        this.world = ((World)previousLocation.getExtent()).getUniqueId();
        this.previousx = previousLocation.getX();
        this.previousy = previousLocation.getY();
        this.previousz = previousLocation.getZ();
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public String getJailName() {
        return this.jailName;
    }

    @Override
    public Optional<UUID> getJailer() {
        return this.jailer.equals(Util.CONSOLE_FAKE_UUID) ? Optional.empty() : Optional.of(this.jailer);
    }

    @Override
    public Optional<Instant> getCreationInstant() {
        return this.creationTime > 0L ? Optional.of(Instant.ofEpochSecond(this.creationTime)) : Optional.empty();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public UUID getJailerInternal() {
        return this.jailer;
    }

    @Override
    public Optional<Location<World>> getPreviousLocation() {
        Optional ow;
        if (this.world != null && (ow = Sponge.getServer().getWorld(this.world)).isPresent() && this.previousx != 0.0 && this.previousy != -1.0 && this.previousz != 0.0) {
            return Optional.of(new Location((Extent)ow.get(), this.previousx, this.previousy, this.previousz));
        }
        return Optional.empty();
    }
}

