/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.powertool.services;

import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.modules.powertool.PowertoolKeys;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import org.spongepowered.api.item.ItemType;

public class PowertoolService
implements ServiceBase {
    private final Map<UUID, Map<String, List<String>>> powertools = new HashMap<UUID, Map<String, List<String>>>();
    private final IStorageManager storageManager;

    @Inject
    public PowertoolService(INucleusServiceCollection serviceCollection) {
        this.storageManager = serviceCollection.storageManager();
    }

    public Map<String, List<String>> getPowertools(UUID uuid) {
        Map m = this.powertools.get(uuid);
        if (m == null) {
            m = ((IUserDataObject)this.storageManager.getUserService().getOrNewOnThread(uuid)).get(PowertoolKeys.POWERTOOLS).orElseGet(HashMap::new);
            this.powertools.put(uuid, m);
        }
        return m;
    }

    public Optional<List<String>> getPowertoolForItem(UUID uuid, ItemType item) {
        List<String> tools = this.getPowertools(uuid).get(item.getId());
        if (tools != null) {
            return Optional.of(ImmutableList.copyOf(tools));
        }
        return Optional.empty();
    }

    public void setPowertool(UUID uuid, ItemType type, List<String> commands) {
        this.getPowertools(uuid).put(type.getId(), commands);
        this.setBack(uuid);
    }

    public void clearPowertool(UUID uuid, ItemType type) {
        this.clearPowertool(uuid, type.getId());
    }

    public void clearPowertool(UUID uuid, String type) {
        this.getPowertools(uuid).remove(type);
        this.setBack(uuid);
    }

    public void reset(UUID uuid) {
        this.powertools.remove(uuid);
        this.setBack(uuid);
    }

    private void setBack(UUID uuid) {
        this.storageManager.getUserService().getOrNew(uuid).thenAccept(x -> x.set(PowertoolKeys.POWERTOOLS, this.powertools.getOrDefault(uuid, new HashMap())));
    }
}

