/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.teleport.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.modules.teleport.events.RequestEvent;
import io.github.nucleuspowered.nucleus.modules.teleport.services.PlayerTeleporterService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@EssentialsEquivalent(value={"tpaall"})
@Command(aliases={"tpaall", "tpaskall"}, basePermission={"nucleus.teleport.tpaall.base"}, commandDescriptionKey="tpaall")
public class TeleportAskAllHereCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().flag(new String[]{"f"}).buildWith(GenericArguments.none())};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        ArrayList cancelled = Lists.newArrayList();
        PlayerTeleporterService playerTeleporterService = context.getServiceCollection().getServiceUnchecked(PlayerTeleporterService.class);
        for (Player x : Sponge.getServer().getOnlinePlayers()) {
            if (context.is(x)) continue;
            RequestEvent.PlayerToCause event = new RequestEvent.PlayerToCause(Sponge.getCauseStackManager().getCurrentCause(), x);
            if (Sponge.getEventManager().post((Event)event)) {
                cancelled.add(x);
                continue;
            }
            playerTeleporterService.requestTeleport(context.getIfPlayer(), x, 0.0, 0, x, context.getIfPlayer(), context.getOne("f", Boolean.class).orElse(false) == false, false, true, p -> {}, "command.tpahere.question");
        }
        context.sendMessage("command.tpaall.success", new Object[0]);
        if (!cancelled.isEmpty()) {
            context.sendMessage("command.tpall.cancelled", cancelled.stream().map(User::getName).collect(Collectors.joining(", ")));
        }
        return context.successResult();
    }
}

