/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.modifier.impl;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.config.CommandModifiersConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.control.CommandControl;
import io.github.nucleuspowered.nucleus.scaffold.command.modifier.ICommandModifier;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.time.Duration;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Identifiable;

public class CooldownModifier
implements ICommandModifier {
    private static final String COOLDOWN = "cooldown";

    public String getId() {
        return "nucleus:has_cooldown";
    }

    public String getName() {
        return "Cooldown Modifier";
    }

    @Override
    public void getDefaultNode(ConfigurationNode node, IMessageProviderService messageProviderService) {
        ConfigurationNode n = node.getNode(new Object[]{COOLDOWN});
        if (n instanceof CommentedConfigurationNode) {
            ((CommentedConfigurationNode)n).setComment(messageProviderService.getMessageString("config.cooldown", new Object[0]));
        }
        n.setValue((Object)0);
    }

    @Override
    public void setDataFromNode(CommandModifiersConfig config, ConfigurationNode node) {
        config.setCooldown(node.getNode(new Object[]{COOLDOWN}).getInt(0));
    }

    @Override
    public void setValueFromOther(CommandModifiersConfig from, CommandModifiersConfig to) {
        to.setCooldown(from.getCooldown());
    }

    @Override
    public boolean canExecuteModifier(INucleusServiceCollection serviceCollection, CommandSource source) throws CommandException {
        return source instanceof Player;
    }

    @Override
    public Optional<Text> testRequirement(ICommandContext.Mutable<? extends CommandSource> source, CommandControl control, INucleusServiceCollection serviceCollection, CommandModifier modifier) throws CommandException {
        Object c = source.getCommandSource();
        return serviceCollection.cooldownService().getCooldown(control.getModifierKey(), (Identifiable)source.getIfPlayer()).map(duration -> serviceCollection.messageProvider().getMessageFor((CommandSource)c, "cooldown.message", source.getTimeString(duration.getSeconds())));
    }

    @Override
    public void onCompletion(ICommandContext<? extends CommandSource> source, CommandControl control, INucleusServiceCollection serviceCollection, CommandModifier modifier) throws CommandException {
        serviceCollection.cooldownService().setCooldown(control.getModifierKey(), (Identifiable)source.getIfPlayer(), Duration.ofSeconds(source.getCooldown()));
    }
}

