/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga;

import com.google.common.collect.Lists;
import com.sosnitzka.taiga.Alloys;
import com.sosnitzka.taiga.Blocks;
import com.sosnitzka.taiga.Fluids;
import com.sosnitzka.taiga.Items;
import com.sosnitzka.taiga.MaterialTraits;
import com.sosnitzka.taiga.proxy.CommonProxy;
import com.sosnitzka.taiga.recipes.CraftingRegistry;
import com.sosnitzka.taiga.recipes.SmeltingRegistry;
import com.sosnitzka.taiga.util.Utils;
import com.sosnitzka.taiga.world.WorldGen;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.materials.BowMaterialStats;

@Mod(modid="taiga", version="1.12.2-1.3.3", guiFactory="com.sosnitzka.taiga.TAIGAGuiFactory", dependencies="required-after:tconstruct@[1.10.2-2.5.0,);required-after:mantle@[1.10.2-1.0.0,)", acceptedMinecraftVersions="[1.12.2]")
public class TAIGA {
    public static final String MODID = "taiga";
    public static final String VERSION = "1.12.2-1.3.3";
    public static final String GUIFACTORY = "com.sosnitzka.taiga.TAIGAGuiFactory";
    public static Logger logger;
    @SidedProxy(clientSide="com.sosnitzka.taiga.proxy.ClientProxy", serverSide="com.sosnitzka.taiga.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static List<MaterialIntegration> integrateList;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        Fluids.register();
        Blocks.register(false);
        Blocks.registerItems();
        Items.register();
        proxy.initConfig();
        this.registerTinkerMaterials();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.registerModels();
        proxy.regsiterKeyBindings();
        Fluids.registerfromItem();
        GameRegistry.registerWorldGenerator((IWorldGenerator)WorldGen.getInstance(), (int)100);
        proxy.registerHarvestLevels();
        Blocks.register(true);
        Alloys.register();
        this.registerTinkerMaterials();
        SmeltingRegistry.register();
        CraftingRegistry.register();
        for (MaterialIntegration m : integrateList) {
            m.integrate();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.registerBookPages();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        proxy.registerServerCommands(event);
    }

    private void registerTinkerMaterials() {
        BowMaterialStats shitty = new BowMaterialStats(0.2f, 0.4f, -1.0f);
        Utils.integrateMaterial("Tiberium", MaterialTraits.tiberium, (Fluid)Fluids.tiberiumFluid, 80, 3.3f, 4.0f, 0.7f, -25, 50, 2, shitty, true, false);
        Utils.integrateMaterial("Aurorium", MaterialTraits.aurorium, (Fluid)Fluids.auroriumFluid, 750, 3.6f, 3.78f, 0.77f, 25, 130, 4, 0.45f, 1.0f, 1);
        Utils.integrateMaterial("Prometheum", MaterialTraits.prometheum, (Fluid)Fluids.prometheumFluid, 844, 4.75f, 6.6f, 1.2f, 25, 50, 5, 0.2f, 0.6f, 3);
        Utils.integrateMaterial("Duranite", MaterialTraits.duranite, (Fluid)Fluids.duraniteFluid, 1550, 3.2f, 3.2f, 1.16f, 100, 100, 5, 0.3f, 1.4f, 2);
        Utils.integrateMaterial("Valyrium", MaterialTraits.valyrium, (Fluid)Fluids.valyriumFluid, 1111, 5.37f, 4.8f, 1.3f, 100, 100, 6, 1.1f, 1.2f, 4);
        Utils.integrateMaterial("Vibranium", MaterialTraits.vibranium, (Fluid)Fluids.vibraniumFluid, 1235, 7.62f, 8.1f, 1.3f, 100, 100, 7, 1.1f, 1.8f, 4);
        Utils.integrateMaterial("Terrax", MaterialTraits.terrax, (Fluid)Fluids.terraxFluid, 444, 4.77f, 2.9f, 0.8f, 100, 50, 4, shitty, true, true);
        Utils.integrateMaterial("Palladium", MaterialTraits.palladium, (Fluid)Fluids.palladiumFluid, 797, 4.35f, 6.8f, 1.3f, 130, -50, 5, 0.5f, 0.2f, 3);
        Utils.integrateMaterial("Uru", MaterialTraits.uru, (Fluid)Fluids.uruFluid, 877, 2.0f, 7.2f, 1.5f, -50, 175, 6, 1.3f, 0.8f, 6);
        Utils.integrateMaterial("Eezo", MaterialTraits.eezo, (Fluid)Fluids.eezoFluid, 50, 23.0f, 3.5f, 0.1f, 10, 10, 4, shitty, true, false);
        Utils.integrateMaterial("Basalt", MaterialTraits.basalt, (Fluid)Fluids.basaltFluid, 200, 3.0f, 2.5f, 0.5f, -25, 25, 0, shitty, true, false);
        Utils.integrateMaterial("Triberium", MaterialTraits.triberium, (Fluid)Fluids.triberiumFluid, 223, 6.2f, 8.35f, 0.63f, 50, 50, 2, shitty, true, true);
        Utils.integrateMaterial("Fractum", MaterialTraits.fractum, (Fluid)Fluids.fractumFluid, 538, 5.71f, 6.93f, 0.88f, 58, 117, 2, shitty);
        Utils.integrateMaterial("Violium", MaterialTraits.violium, (Fluid)Fluids.violiumFluid, 925, 3.8f, 3.75f, 0.9f, 175, 50, 4, 0.45f, 0.95f, 1);
        Utils.integrateMaterial("Proxii", MaterialTraits.proxii, (Fluid)Fluids.proxiiFluid, 625, 6.8f, 4.21f, 1.25f, 80, 25, 5, 0.35f, 0.5f, 3);
        Utils.integrateMaterial("Tritonite", MaterialTraits.tritonite, (Fluid)Fluids.tritoniteFluid, 780, 8.0f, 3.3f, 1.45f, -25, 150, 4, shitty);
        Utils.integrateMaterial("Ignitz", MaterialTraits.ignitz, (Fluid)Fluids.ignitzFluid, 350, 2.0f, 6.66f, 0.85f, 150, 250, 4, 0.8f, 0.8f, 3);
        Utils.integrateMaterial("Imperomite", MaterialTraits.imperomite, (Fluid)Fluids.imperomiteFluid, 1350, 4.65f, 5.9f, 1.15f, -100, 150, 5, 1.2f, 1.8f, 2);
        Utils.integrateMaterial("Solarium", MaterialTraits.solarium, (Fluid)Fluids.solariumFluid, 1100, 24.0f, 7.0f, 1.25f, 150, 150, 7, 0.8f, 1.5f, 5);
        Utils.integrateMaterial("Nihilite", MaterialTraits.nihilite, (Fluid)Fluids.nihiliteFluid, 400, 2.8f, 4.5f, 0.77f, 350, 155, 6, 1.5f, 0.8f, 3);
        Utils.integrateMaterial("Adamant", MaterialTraits.adamant, (Fluid)Fluids.adamantFluid, 1750, 6.0f, 6.0f, 2.0f, 0, 0, 7, 0.35f, 1.85f, 8);
        Utils.integrateMaterial("Dyonite", MaterialTraits.dyonite, (Fluid)Fluids.dyoniteFluid, 900, 6.45f, 5.0f, 0.66f, -50, 250, 5, 2.0f, 0.9f, -1);
        Utils.integrateMaterial("Nucleum", MaterialTraits.nucleum, (Fluid)Fluids.nucleumFluid, 505, 17.5f, 9.5f, 1.05f, 100, 125, 6, shitty);
        Utils.integrateMaterial("Lumix", MaterialTraits.lumix, (Fluid)Fluids.lumixFluid, 666, 3.84f, 3.92f, 0.85f, 250, 200, 4, 0.8f, 1.3f, 1);
        Utils.integrateMaterial("Seismum", MaterialTraits.seismum, (Fluid)Fluids.seismumFluid, 780, 3.66f, 6.05f, 0.95f, 250, 50, 4, shitty);
        Utils.integrateMaterial("Astrium", MaterialTraits.astrium, (Fluid)Fluids.astriumFluid, 750, 8.35f, 5.4f, 0.95f, -100, 200, 4, 0.7f, 0.8f, 2);
        Utils.integrateMaterial("Niob", MaterialTraits.niob, (Fluid)Fluids.niobFluid, 700, 4.5f, 4.5f, 2.0f, 200, 50, 4, shitty);
        Utils.integrateMaterial("Yrdeen", MaterialTraits.yrdeen, (Fluid)Fluids.yrdeenFluid, 999, 9.1f, 3.0f, 1.35f, 150, 250, 4, shitty);
        Utils.integrateMaterial("Meteorite", MaterialTraits.meteorite, (Fluid)Fluids.meteoriteFluid, 1500, 1.5f, 1.5f, 0.5f, 0, 0, 3, shitty);
        Utils.integrateMaterial("Obsidiorite", MaterialTraits.obsidiorite, (Fluid)Fluids.obsidioriteFluid, 1500, 0.5f, 0.5f, 1.0f, -100, 100, 4, shitty);
        Utils.integrateOre("Osram", (Fluid)Fluids.osramFluid);
        Utils.integrateOre("Abyssum", (Fluid)Fluids.abyssumFluid);
        Utils.integrateOre("Iox", (Fluid)Fluids.ioxFluid);
        Utils.integrateOre("Karmesine", (Fluid)Fluids.karmesineFluid);
        Utils.integrateOre("Ovium", (Fluid)Fluids.oviumFluid);
        Utils.integrateOre("Jauxum", (Fluid)Fluids.jauxumFluid);
        Utils.integrateOre("Dilithium", (Fluid)Fluids.dilithiumFluid);
    }

    static {
        integrateList = Lists.newArrayList();
    }
}

