/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.api.implementation;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import net.luckperms.api.platform.Platform;
import net.luckperms.api.platform.PluginMetadata;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ApiPlatform
implements Platform,
PluginMetadata {
    private final LuckPermsPlugin plugin;

    public ApiPlatform(LuckPermsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public @NonNull String getVersion() {
        return this.plugin.getBootstrap().getVersion();
    }

    @Override
    public @NonNull String getApiVersion() {
        String[] version = this.plugin.getBootstrap().getVersion().split("\\.");
        return version[0] + '.' + version[1];
    }

    @Override
    public @NonNull Platform.Type getType() {
        return this.plugin.getBootstrap().getType();
    }

    @Override
    public @NonNull Set<UUID> getUniqueConnections() {
        return Collections.unmodifiableSet(this.plugin.getConnectionListener().getUniqueConnections());
    }

    @Override
    public @NonNull Collection<String> getKnownPermissions() {
        return this.plugin.getPermissionRegistry().rootAsList();
    }

    @Override
    public @NonNull Instant getStartTime() {
        return this.plugin.getBootstrap().getStartupTime();
    }
}

