/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.model;

import java.util.Map;
import java.util.OptionalInt;
import me.lucko.luckperms.common.cache.Cache;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WeightCache
extends Cache<OptionalInt> {
    private final Group group;

    public WeightCache(Group group) {
        this.group = group;
    }

    @Override
    protected @NonNull OptionalInt supply() {
        Map<String, Integer> configWeights;
        Integer value;
        boolean seen = false;
        int weight = 0;
        for (WeightNode n : this.group.getOwnNodes(NodeType.WEIGHT, QueryOptionsImpl.DEFAULT_NON_CONTEXTUAL)) {
            int value2 = n.getWeight();
            if (seen && value2 <= weight) continue;
            seen = true;
            weight = value2;
        }
        if (!seen && (value = (configWeights = this.group.getPlugin().getConfiguration().get(ConfigKeys.GROUP_WEIGHTS)).get(this.group.getObjectName().toLowerCase())) != null) {
            seen = true;
            weight = value;
        }
        return seen ? OptionalInt.of(weight) : OptionalInt.empty();
    }
}

