/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.reference;

import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubject;
import me.lucko.luckperms.sponge.service.model.LPSubjectReference;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.service.permission.Subject;

final class CachedSubjectReference
implements LPSubjectReference {
    private static final long CACHE_TIME = TimeUnit.MINUTES.toMillis(5L);
    private final LPPermissionService service;
    private final @NonNull String collectionIdentifier;
    private final @NonNull String subjectIdentifier;
    private long lastLookup = 0L;
    private WeakReference<LPSubject> cache = null;

    CachedSubjectReference(LPPermissionService service, String collectionIdentifier, String subjectIdentifier) {
        this.service = Objects.requireNonNull(service);
        this.collectionIdentifier = Objects.requireNonNull(collectionIdentifier);
        this.subjectIdentifier = Objects.requireNonNull(subjectIdentifier);
    }

    @Override
    public @NonNull String getCollectionIdentifier() {
        return this.collectionIdentifier;
    }

    @Override
    public @NonNull String getSubjectIdentifier() {
        return this.subjectIdentifier;
    }

    void fillCache(LPSubject subject) {
        LPSubject sub = this.tryCache();
        if (sub == null) {
            this.lastLookup = System.currentTimeMillis();
            this.cache = new WeakReference<LPSubject>(subject);
        } else if (sub == subject) {
            this.lastLookup = System.currentTimeMillis();
        }
    }

    private LPSubject tryCache() {
        if (System.currentTimeMillis() - this.lastLookup < CACHE_TIME && this.cache != null) {
            return (LPSubject)this.cache.get();
        }
        return null;
    }

    private synchronized LPSubject resolveDirectly() {
        LPSubject s = this.tryCache();
        if (s != null) {
            return s;
        }
        s = this.service.getCollection(this.collectionIdentifier).loadSubject(this.subjectIdentifier).join();
        this.lastLookup = System.currentTimeMillis();
        this.cache = new WeakReference<LPSubject>(s);
        return s;
    }

    @Override
    public @NonNull CompletableFuture<LPSubject> resolveLp() {
        LPSubject s = this.tryCache();
        if (s != null) {
            return CompletableFuture.completedFuture(s);
        }
        return CompletableFuture.supplyAsync(this::resolveDirectly);
    }

    @Override
    public @NonNull CompletableFuture<Subject> resolve() {
        LPSubject s = this.tryCache();
        if (s != null) {
            return CompletableFuture.completedFuture(s.sponge());
        }
        return CompletableFuture.supplyAsync(() -> this.resolveDirectly().sponge());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LPSubjectReference)) {
            return false;
        }
        LPSubjectReference other = (LPSubjectReference)o;
        return this.collectionIdentifier.equals(other.getCollectionIdentifier()) && this.subjectIdentifier.equals(other.getSubjectIdentifier());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.collectionIdentifier.hashCode();
        result = result * 59 + this.subjectIdentifier.hashCode();
        return result;
    }

    public String toString() {
        return "luckperms.SubjectReference(collection=" + this.collectionIdentifier + ", subject=" + this.subjectIdentifier + ")";
    }
}

