/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.config;

import java.math.BigDecimal;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.text.Text;

public class TECurrency
implements Currency {
    private Text singular;
    private Text plural;
    private Text symbol;
    private int numFractionDigits;
    private boolean isDefault;
    private boolean prefixSymbol;
    boolean isTransferable;
    private BigDecimal startBalance;

    public TECurrency(Text singular, Text plural, Text symbol, int numFractionDigits, boolean defaultCurrency, boolean prefixSymbol, boolean isTransferable, BigDecimal startBalance) {
        this.singular = singular;
        this.plural = plural;
        this.symbol = symbol;
        this.numFractionDigits = numFractionDigits;
        this.isDefault = defaultCurrency;
        this.prefixSymbol = prefixSymbol;
        this.isTransferable = isTransferable;
        this.startBalance = startBalance;
    }

    public String getName() {
        return this.singular.toPlain();
    }

    public String getId() {
        return "totaleconomy:" + this.singular.toPlain().toLowerCase();
    }

    public Text getDisplayName() {
        return this.singular;
    }

    public Text getPluralDisplayName() {
        return this.plural;
    }

    public Text getSymbol() {
        return this.symbol;
    }

    public Text format(BigDecimal amount, int numFractionDigits) {
        if (this.prefixSymbol) {
            return Text.of((Object[])new Object[]{this.symbol, amount.setScale(numFractionDigits, 4)});
        }
        return Text.of((Object[])new Object[]{amount.setScale(numFractionDigits, 4), this.symbol});
    }

    public int getDefaultFractionDigits() {
        return this.numFractionDigits;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isTransferable() {
        return this.isTransferable;
    }

    public BigDecimal getStartingBalance() {
        return this.startBalance;
    }
}

