/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.key;

import me.lucko.luckperms.lib.adventure.key.Key;
import me.lucko.luckperms.lib.adventure.key.KeyedValue;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class KeyedValueImpl<T>
implements KeyedValue<T> {
    private final Key key;
    private final T value;

    KeyedValueImpl(Key key, T value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public @NonNull Key key() {
        return this.key;
    }

    @Override
    public @NonNull T value() {
        return this.value;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KeyedValueImpl that = (KeyedValueImpl)other;
        return this.key.equals(that.key) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public @NonNull String toString() {
        return "KeyedValueImpl{key=" + this.key + ", value=" + this.value + '}';
    }
}

