/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.nbt;

import java.util.Map;
import java.util.Set;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTag;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTagType;
import me.lucko.luckperms.lib.adventure.nbt.BinaryTagTypes;
import me.lucko.luckperms.lib.adventure.nbt.CompoundBinaryTagImpl;
import me.lucko.luckperms.lib.adventure.nbt.CompoundTagBuilder;
import me.lucko.luckperms.lib.adventure.nbt.CompoundTagSetter;
import me.lucko.luckperms.lib.adventure.nbt.ListBinaryTag;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface CompoundBinaryTag
extends BinaryTag,
CompoundTagSetter<CompoundBinaryTag>,
Iterable<Map.Entry<String, ? extends BinaryTag>> {
    public static @NonNull CompoundBinaryTag empty() {
        return CompoundBinaryTagImpl.EMPTY;
    }

    public static @NonNull Builder builder() {
        return new CompoundTagBuilder();
    }

    default public @NonNull BinaryTagType<CompoundBinaryTag> type() {
        return BinaryTagTypes.COMPOUND;
    }

    public @NonNull Set<String> keySet();

    public @Nullable BinaryTag get(String var1);

    default public boolean getBoolean(@NonNull String key) {
        return this.getBoolean(key, false);
    }

    default public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        return this.getByte(key) != 0 || defaultValue;
    }

    default public byte getByte(@NonNull String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(@NonNull String var1, byte var2);

    default public short getShort(@NonNull String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(@NonNull String var1, short var2);

    default public int getInt(@NonNull String key) {
        return this.getInt(key, 0);
    }

    public int getInt(@NonNull String var1, int var2);

    default public long getLong(@NonNull String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(@NonNull String var1, long var2);

    default public float getFloat(@NonNull String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(@NonNull String var1, float var2);

    default public double getDouble(@NonNull String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(@NonNull String var1, double var2);

    public byte @NonNull [] getByteArray(@NonNull String var1);

    public byte @NonNull [] getByteArray(@NonNull String var1, byte @NonNull [] var2);

    default public @NonNull String getString(@NonNull String key) {
        return this.getString(key, "");
    }

    public @NonNull String getString(@NonNull String var1, @NonNull String var2);

    default public @NonNull ListBinaryTag getList(@NonNull String key) {
        return this.getList(key, ListBinaryTag.empty());
    }

    public @NonNull ListBinaryTag getList(@NonNull String var1, @NonNull ListBinaryTag var2);

    default public @NonNull ListBinaryTag getList(@NonNull String key, @NonNull BinaryTagType<? extends BinaryTag> expectedType) {
        return this.getList(key, expectedType, ListBinaryTag.empty());
    }

    public @NonNull ListBinaryTag getList(@NonNull String var1, @NonNull BinaryTagType<? extends BinaryTag> var2, @NonNull ListBinaryTag var3);

    default public @NonNull CompoundBinaryTag getCompound(@NonNull String key) {
        return this.getCompound(key, CompoundBinaryTag.empty());
    }

    public @NonNull CompoundBinaryTag getCompound(@NonNull String var1, @NonNull CompoundBinaryTag var2);

    public int @NonNull [] getIntArray(@NonNull String var1);

    public int @NonNull [] getIntArray(@NonNull String var1, int @NonNull [] var2);

    public long @NonNull [] getLongArray(@NonNull String var1);

    public long @NonNull [] getLongArray(@NonNull String var1, long @NonNull [] var2);

    public static interface Builder
    extends CompoundTagSetter<Builder> {
        public @NonNull CompoundBinaryTag build();
    }
}

