/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.adventure.text;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.lucko.luckperms.lib.adventure.text.AbstractComponent;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentBuilder;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.event.ClickEvent;
import me.lucko.luckperms.lib.adventure.text.event.HoverEventSource;
import me.lucko.luckperms.lib.adventure.text.format.Style;
import me.lucko.luckperms.lib.adventure.text.format.TextColor;
import me.lucko.luckperms.lib.adventure.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ScopedComponent<C extends Component>
extends Component {
    public @NonNull C children(@NonNull List<? extends ComponentLike> var1);

    public @NonNull C style(@NonNull Style var1);

    default public @NonNull C style(@NonNull Consumer<Style.Builder> style) {
        return (C)Component.super.style(style);
    }

    default public @NonNull C style(@NonNull Style.Builder style) {
        return (C)Component.super.style(style);
    }

    default public @NonNull C mergeStyle(@NonNull Component that) {
        return (C)Component.super.mergeStyle(that);
    }

    default public @NonNull C mergeStyle(@NonNull Component that, Style.Merge ... merges) {
        return (C)Component.super.mergeStyle(that, merges);
    }

    default public @NonNull C append(@NonNull Component component) {
        if (component == Component.empty()) {
            return (C)this;
        }
        this.detectCycle(component);
        List<Component> oldChildren = this.children();
        return this.children(AbstractComponent.addOne(oldChildren, component));
    }

    default public @NonNull C append(@NonNull ComponentLike component) {
        return (C)Component.super.append(component);
    }

    default public @NonNull C append(@NonNull ComponentBuilder<?, ?> builder) {
        return (C)Component.super.append(builder);
    }

    default public @NonNull C mergeStyle(@NonNull Component that, @NonNull Set<Style.Merge> merges) {
        return (C)Component.super.mergeStyle(that, merges);
    }

    default public @NonNull C color(@Nullable TextColor color) {
        return (C)Component.super.color(color);
    }

    default public @NonNull C colorIfAbsent(@Nullable TextColor color) {
        return (C)Component.super.colorIfAbsent(color);
    }

    @Override
    default public @NonNull Component decorate(@NonNull TextDecoration decoration) {
        return Component.super.decorate(decoration);
    }

    default public @NonNull C decoration(@NonNull TextDecoration decoration, boolean flag) {
        return (C)Component.super.decoration(decoration, flag);
    }

    default public @NonNull C decoration(@NonNull TextDecoration decoration, @NonNull TextDecoration.State state) {
        return (C)Component.super.decoration(decoration, state);
    }

    default public @NonNull C clickEvent(@Nullable ClickEvent event) {
        return (C)Component.super.clickEvent(event);
    }

    default public @NonNull C hoverEvent(@Nullable HoverEventSource<?> event) {
        return (C)Component.super.hoverEvent(event);
    }

    default public @NonNull C insertion(@Nullable String insertion) {
        return (C)Component.super.insertion(insertion);
    }
}

