/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.Forestry;
import forestry.api.core.IGameMode;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.utils.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class GameMode
implements IGameMode {
    private static final String GAMEMODE_KEY = "gamemode";
    private String identifier = "EASY";
    private final Map<String, Boolean> booleanSettings = new HashMap<String, Boolean>();
    private final Map<String, Integer> integerSettings = new HashMap<String, Integer>();
    private final Map<String, Float> floatSettings = new HashMap<String, Float>();
    private static final float ENERGY_DEMAND_MODIFIER = 1.0f;
    private static final float FUEL_MODIFIER = 1.0f;
    private static final int FARM_FERTILIZER_MODIFIER = 4;
    private static final int recipeFertilizerOutputApatite = 8;
    private static final int recipeFertilizerOutputAsh = 16;
    private static final int recipeCompostOutputWheat = 4;
    private static final int recipeCompostOutputAsh = 1;
    private static final int recipeHumusOutputFertilizer = 8;
    private static final int recipeHumusOutputCompost = 8;
    private static final int recipeBogEarthOutputBucket = 6;
    private static final int recipeBogEarthOutputCans = 8;
    private static final int recipeCanOutput = 12;
    private static final int recipeCapsuleOutput = 4;
    private static final int recipeRefractoryOutput = 4;
    private static final int FERMENTATION_DURATION_FERTILIZER = 200;
    private static final int FERMENTATION_DURATION_COMPOST = 250;
    private static final int FERMENTATION_DURATION_MULCH = 250;
    private static final int FERMENTED_CYCLE_FERTILIZER = 56;
    private static final int FERMENTED_CYCLE_COMPOST = 48;
    private static final int FERMENTED_CYCLE_MULCH = 48;
    private static final int FERMENTED_SAPLING = 250;
    private static final int FERMENTED_CACTI = 50;
    private static final int FERMENTED_WHEAT = 50;
    private static final int FERMENTED_CANE = 50;
    private static final int FERMENTED_MUSHROOM = 50;
    private static final int SQUEEZED_LIQUID_SEED = 10;
    private static final int SQUEEZED_LIQUID_APPLE = 200;
    private static final int SQUEEZED_MULCH_APPLE = 20;

    public GameMode(String identifier) {
        this.identifier = identifier;
        String category = "gamemodes/" + identifier;
        File configFile = new File(Forestry.instance.getConfigFolder(), category + ".cfg");
        LocalizedConfiguration config = new LocalizedConfiguration(configFile, "1.0.0");
        this.initSettingFloat(config, "energy", "demand.modifier", 1.0f);
        this.initSettingBoolean(config, "energy", "engine.clockwork", true);
        this.initSettingInt(config, "farms", "fertilizer.modifier", 4);
        this.initSettingFloat(config, "fuel.ethanol", "generator", 1.0f);
        this.initSettingFloat(config, "fuel.ethanol", "combustion", 1.0f);
        this.initSettingFloat(config, "fuel.biomass", "generator", 1.0f);
        this.initSettingFloat(config, "fuel.biomass", "biogas", 1.0f);
        this.initSettingInt(config, "recipe.output.fertilizer", "apatite", 8);
        this.initSettingInt(config, "recipe.output.fertilizer", "ash", 16);
        this.initSettingInt(config, "recipe.output.compost", "wheat", 4);
        this.initSettingInt(config, "recipe.output.compost", "ash", 1);
        this.initSettingInt(config, "recipe.output.humus", "fertilizer", 8);
        this.initSettingInt(config, "recipe.output.humus", "compost", 8);
        this.initSettingInt(config, "recipe.output.bogearth", "bucket", 6);
        this.initSettingInt(config, "recipe.output.bogearth", "can", 8);
        this.initSettingInt(config, "recipe.output", "can", 12);
        this.initSettingInt(config, "recipe.output", "capsule", 4);
        this.initSettingInt(config, "recipe.output", "refractory", 4);
        this.initSettingInt(config, "fermenter.cycles", "fertilizer", 200);
        this.initSettingInt(config, "fermenter.cycles", "compost", 250);
        this.initSettingInt(config, "fermenter.cycles", "mulch", 250);
        this.initSettingInt(config, "fermenter.value", "fertilizer", 56);
        this.initSettingInt(config, "fermenter.value", "compost", 48);
        this.initSettingInt(config, "fermenter.value", "mulch", 48);
        this.initSettingInt(config, "fermenter.yield", "sapling", 250);
        this.initSettingInt(config, "fermenter.yield", "cactus", 50);
        this.initSettingInt(config, "fermenter.yield", "wheat", 50);
        this.initSettingInt(config, "fermenter.yield", "cane", 50);
        this.initSettingInt(config, "fermenter.yield", "mushroom", 50);
        this.initSettingInt(config, "squeezer.liquid", "seed", 10);
        this.initSettingInt(config, "squeezer.liquid", "apple", 200);
        this.initSettingInt(config, "squeezer.mulch", "apple", 20);
        config.save();
    }

    private void initSettingFloat(LocalizedConfiguration config, String category, String name, float defaultValue) {
        String fullName = category + '.' + name;
        float floatValue = config.getFloatLocalized("gamemode." + category, name, defaultValue, 0.0f, 10.0f);
        this.floatSettings.put(fullName, Float.valueOf(floatValue));
    }

    private void initSettingInt(LocalizedConfiguration config, String category, String key, int defaultValue) {
        String fullKey = category + '.' + key;
        int intValue = config.getIntLocalized("gamemode." + category, key, defaultValue, 0, 2000);
        this.integerSettings.put(fullKey, intValue);
    }

    private void initSettingBoolean(LocalizedConfiguration config, String category, String key, boolean defaultValue) {
        String fullKey = category + '.' + key;
        boolean booleanValue = config.getBooleanLocalized("gamemode." + category, key, defaultValue);
        this.booleanSettings.put(fullKey, booleanValue);
    }

    @Override
    public int getIntegerSetting(String ident) {
        if (this.integerSettings.containsKey(ident)) {
            return this.integerSettings.get(ident);
        }
        Log.warning("No such setting: " + ident, new Object[0]);
        return -1;
    }

    @Override
    public float getFloatSetting(String ident) {
        if (this.floatSettings.containsKey(ident)) {
            return this.floatSettings.get(ident).floatValue();
        }
        Log.warning("No such setting: " + ident, new Object[0]);
        return 1.0f;
    }

    @Override
    public boolean getBooleanSetting(String ident) {
        if (this.booleanSettings.containsKey(ident)) {
            return this.booleanSettings.get(ident);
        }
        Log.warning("No such setting: " + ident, new Object[0]);
        return false;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

