/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.schedule;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Units;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Modifiers {
    private static final Pattern MODIFIER = Pattern.compile("(?<operator>[&^$])?(?<inverse>[!])?(?:(?:(?<lower>[0-9]+)[-](?<upper>[0-9]+))|[/](?<increment>(?:[1-9]|0(?=[0]*[1-9]))[0-9]*)|(?<number>[0-9]+)|(?<wildcard>[*]))");
    private static final Pattern SEPARATOR = Pattern.compile("[,]|(?<![,][ _]?)(?=[&^$])");
    private static final Pattern SCHEDULE = Pattern.compile("(?<!,)[ _](?![&^$])");

    public static Set<Integer> buildSet(Units unit, String modifier) throws IllegalArgumentException {
        Preconditions.checkArgument((!modifier.isEmpty() ? 1 : 0) != 0, (Object)"Modifier must be defined.");
        HashSet unitSet = Sets.newHashSet();
        for (String mod : SEPARATOR.split(modifier)) {
            Matcher matcher = MODIFIER.matcher(mod.trim());
            Preconditions.checkArgument((boolean)matcher.matches(), (Object)("Modifier did not match expected format. Modifier:[" + mod + "]"));
            try {
                HashSet modifierSet = Sets.newHashSet();
                if (matcher.group("lower") != null) {
                    int upper;
                    int lower = unit.checkBounds(Integer.parseInt(matcher.group("lower")));
                    Preconditions.checkArgument((lower <= (upper = unit.checkBounds(Integer.parseInt(matcher.group("upper")))) ? 1 : 0) != 0, (Object)("Lower bound cannot be greater than the upper bound. | Modifier:[" + mod + "]"));
                    modifierSet.addAll(IntStream.rangeClosed(lower, upper).boxed().collect(Collectors.toSet()));
                } else if (matcher.group("increment") != null) {
                    int increment = unit.checkBounds(Integer.parseInt(matcher.group("increment")));
                    modifierSet.addAll(unit.values.stream().filter(i -> i % increment == 0).collect(Collectors.toSet()));
                } else if (matcher.group("number") != null) {
                    modifierSet.add(unit.checkBounds(Integer.parseInt(matcher.group("number"))));
                } else if (matcher.group("wildcard") != null) {
                    modifierSet.addAll(unit.values);
                }
                if (matcher.group("inverse") != null) {
                    modifierSet = Sets.difference(unit.values, (Set)modifierSet);
                }
                switch (Optional.ofNullable(matcher.group("operator")).orElse("&")) {
                    case "&": {
                        unitSet = Sets.union((Set)unitSet, (Set)modifierSet);
                        break;
                    }
                    case "^": {
                        unitSet = Sets.intersection((Set)unitSet, (Set)modifierSet);
                        break;
                    }
                    case "$": {
                        unitSet = Sets.difference((Set)unitSet, (Set)modifierSet);
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expected an integer parsing modifier. | Modifier:[" + mod + "]", e);
            }
        }
        return Sets.newHashSet((Iterable)unitSet);
    }

    public static String buildModifier(Units unit, Set<Integer> set) {
        Preconditions.checkArgument((!set.isEmpty() ? 1 : 0) != 0, (Object)"Set must be defined.");
        Preconditions.checkArgument((boolean)unit.values.containsAll(set), (Object)("Set contains illegal values. | Values:[" + Sets.difference(unit.values, set) + "]"));
        return String.join((CharSequence)", ", set.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public static EnumMap<Units, Set<Integer>> buildSchedule(String schedule) throws IllegalArgumentException {
        Preconditions.checkArgument((!schedule.isEmpty() ? 1 : 0) != 0, (Object)"Schedule must be defined");
        EnumMap sets = Maps.newEnumMap(Units.class);
        String[] modifiers = SCHEDULE.split(schedule);
        Preconditions.checkArgument((modifiers.length == Units.values().length ? 1 : 0) != 0, (Object)("Schedule did not define the expected number of modifiers. | Expected:[" + Units.values().length + "]"));
        for (Units unit : Units.values()) {
            sets.put(unit, Modifiers.buildSet(unit, modifiers[5 - unit.ordinal()]));
        }
        return sets;
    }
}

