/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.client;

import crazypants.enderio.base.invpanel.database.ItemEntryBase;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;

public class ItemEntry
extends ItemEntryBase {
    private String name;
    private String modId;
    private String lowerCaseLocName;
    private int count;
    @Nonnull
    private ItemStack stack = ItemStack.field_190927_a;

    public ItemEntry(int dbID, int hash, int itemID, int meta, NBTTagCompound nbt) {
        super(dbID, hash, itemID, meta, nbt);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
        this.stack = ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack makeItemStack() {
        if (this.stack.func_190926_b()) {
            this.stack = new ItemStack(this.getItem(), this.getCount(), this.getMeta());
            this.stack.func_77982_d(this.getNbt());
        }
        return this.stack;
    }

    @Nonnull
    public String getUnlocName() {
        if (this.name == null) {
            this.findUnlocName();
        }
        return this.name;
    }

    @Nonnull
    public String getLowercaseUnlocName(Locale locale) {
        if (this.lowerCaseLocName == null) {
            this.lowerCaseLocName = I18n.func_74838_a((String)this.getUnlocName()).toLowerCase(locale);
        }
        return this.lowerCaseLocName;
    }

    private void findUnlocName() {
        ItemStack stack = this.makeItemStack();
        try {
            this.name = stack.func_82833_r();
            if (this.name.isEmpty()) {
                this.name = stack.func_77973_b().func_77658_a();
                if (this.name.isEmpty()) {
                    this.name = stack.func_77973_b().getClass().getName();
                }
            }
        }
        catch (Throwable ex) {
            this.name = "Exception: " + ex.getMessage();
        }
    }

    @Nonnull
    public String getModId() {
        if (this.modId == null) {
            this.findModId();
        }
        return this.modId;
    }

    private void findModId() {
        ResourceLocation resourceName;
        Item item = this.getItem();
        if (item != null && (resourceName = item.delegate.name()) != null) {
            this.modId = resourceName.func_110624_b();
        }
        if (this.modId == null) {
            this.modId = "Unknown";
        }
    }

    @Override
    public String toString() {
        return "ItemEntry [name=" + this.name + ", modId=" + this.modId + ", lowerCaseLocName=" + this.lowerCaseLocName + ", count=" + this.count + ", super=" + super.toString() + "]";
    }
}

