/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.server;

import crazypants.enderio.base.invpanel.database.IChangeLog;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import java.util.ArrayList;

final class ChangeLogList
implements IChangeLog {
    final ArrayList<IChangeLog> clList = new ArrayList(2);

    public ChangeLogList(IChangeLog cl0, IChangeLog cl1) {
        this.clList.add(cl0);
        this.clList.add(cl1);
    }

    @Override
    public void entryChanged(IServerItemEntry entry) {
        for (IChangeLog cl : this.clList) {
            cl.entryChanged(entry);
        }
    }

    @Override
    public void databaseReset() {
        for (IChangeLog cl : this.clList) {
            cl.databaseReset();
        }
    }

    @Override
    public void sendChangeLog() {
        for (IChangeLog cl : this.clList) {
            cl.sendChangeLog();
        }
    }

    IChangeLog remove(IChangeLog cl) {
        this.clList.remove(cl);
        if (this.clList.size() == 1) {
            return this.clList.get(0);
        }
        return this;
    }

    void add(IChangeLog cl) {
        if (!this.clList.contains(cl)) {
            this.clList.add(cl);
        }
    }
}

