/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.util.ItemUtils;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.gui.DoorFactoryGui;
import net.malisis.doors.item.CustomDoorItem;
import net.malisis.doors.item.DoorItem;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.sound.IDoorSound;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DoorFactoryTileEntity
extends TileEntity
implements IInventoryProvider.IDirectInventoryProvider {
    private MalisisInventory inventory;
    private IDoorMovement doorMovement;
    private IDoorSound doorSound;
    private int openingTime = 6;
    private int autoCloseTime = 0;
    private DoorDescriptor.RedstoneBehavior redstoneBehavior = DoorDescriptor.RedstoneBehavior.STANDARD;
    private boolean doubleDoor = true;
    private boolean proximityDetection = false;
    private String code;
    private boolean isCreate = true;
    public MalisisSlot frameSlot = new DoorFactorySlot(true);
    public MalisisSlot topMaterialSlot = new DoorFactorySlot(false);
    public MalisisSlot bottomMaterialSlot = new DoorFactorySlot(false);
    public MalisisSlot doorEditSlot = new DoorEditSlot();
    public MalisisSlot outputSlot = new MalisisSlot();

    public DoorFactoryTileEntity() {
        this.outputSlot.setOutputSlot();
        this.inventory = new MalisisInventory((IInventoryProvider)this, new MalisisSlot[]{this.frameSlot, this.topMaterialSlot, this.bottomMaterialSlot, this.doorEditSlot, this.outputSlot});
    }

    public boolean isCreate() {
        return this.isCreate;
    }

    public void setCreate(boolean isCreate) {
        this.isCreate = isCreate;
    }

    public IDoorMovement getDoorMovement() {
        return this.doorMovement;
    }

    public void setDoorMovement(IDoorMovement doorMovement) {
        this.doorMovement = doorMovement;
    }

    public IDoorSound getDoorSound() {
        return this.doorSound;
    }

    public void setDoorSound(IDoorSound doorSound) {
        this.doorSound = doorSound;
    }

    public int getOpeningTime() {
        return this.openingTime;
    }

    public void setOpeningTime(int openingTime) {
        this.openingTime = openingTime;
    }

    public int getAutoCloseTime() {
        return this.autoCloseTime;
    }

    public void setAutoCloseTime(int autoCloseTime) {
        this.autoCloseTime = autoCloseTime;
    }

    public DoorDescriptor.RedstoneBehavior getRedstoneBehavior() {
        return this.redstoneBehavior;
    }

    public void setRedstoneBehavior(DoorDescriptor.RedstoneBehavior redstoneBehavior) {
        this.redstoneBehavior = redstoneBehavior;
    }

    public boolean isDoubleDoor() {
        return this.doubleDoor;
    }

    public void setDoubleDoor(boolean doubleDoor) {
        this.doubleDoor = doubleDoor;
    }

    public boolean hasProximityDetection() {
        return this.proximityDetection;
    }

    public void setProximityDetection(boolean proximity) {
        this.proximityDetection = proximity;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public MalisisInventory getInventory() {
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public MalisisGui getGui(MalisisInventoryContainer container) {
        return new DoorFactoryGui(this, container);
    }

    public void createDoor() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.canCreateDoor()) {
            return;
        }
        if (this.isCreate) {
            ItemStack expected = CustomDoorItem.fromDoorFactory(this);
            ItemStack output = this.outputSlot.getItemStack();
            if (expected == null) {
                return;
            }
            if (output.func_190916_E() >= output.func_77976_d() || !new ItemUtils.ItemStacksMerger(expected, output).canMerge()) {
                return;
            }
            this.frameSlot.extract(1);
            this.topMaterialSlot.extract(1);
            this.bottomMaterialSlot.extract(1);
            this.outputSlot.insert(expected);
        } else {
            ItemStack doors = this.doorEditSlot.extract(-1);
            NBTTagCompound nbt = doors.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            DoorDescriptor desc = ((DoorItem)doors.func_77973_b()).getDescriptor(doors);
            this.buildDescriptor(desc.getBlock(), desc.getItem()).writeNBT(nbt);
            doors.func_77982_d(nbt);
            this.outputSlot.insert(doors);
        }
    }

    public boolean canCreateDoor() {
        if (this.doorMovement == null || this.doorSound == null || this.openingTime == 0) {
            return false;
        }
        if (this.isCreate) {
            if (this.frameSlot.getItemStack().func_190926_b()) {
                return false;
            }
            if (this.topMaterialSlot.getItemStack().func_190926_b()) {
                return false;
            }
            if (this.bottomMaterialSlot.getItemStack().func_190926_b()) {
                return false;
            }
        } else if (this.doorEditSlot.getItemStack().func_190926_b()) {
            return false;
        }
        return true;
    }

    public DoorDescriptor buildDescriptor(Block block, Item item) {
        DoorDescriptor desc = new DoorDescriptor();
        desc.set(block, item);
        desc.setMovement(this.getDoorMovement());
        desc.setSound(this.getDoorSound());
        desc.setOpeningTime(this.getOpeningTime());
        desc.setAutoCloseTime(this.getAutoCloseTime());
        desc.setDoubleDoor(this.isDoubleDoor());
        desc.setProximityDetection(this.hasProximityDetection());
        desc.setRedstoneBehavior(this.getRedstoneBehavior());
        desc.setCode(this.getCode());
        return desc;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isCreate", this.isCreate);
        if (this.doorMovement != null) {
            nbt.func_74778_a("doorMovement", DoorRegistry.getId(this.doorMovement));
        }
        if (this.doorSound != null) {
            nbt.func_74778_a("doorSound", DoorRegistry.getId(this.doorSound));
        }
        nbt.func_74768_a("openingTime", this.openingTime);
        nbt.func_74768_a("autoCloseTime", this.autoCloseTime);
        nbt.func_74768_a("redstoneBehavior", this.getRedstoneBehavior().ordinal());
        nbt.func_74757_a("doubleDoor", this.doubleDoor);
        nbt.func_74757_a("proximityDetection", this.proximityDetection);
        this.inventory.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isCreate = nbt.func_74767_n("isCreate");
        this.doorMovement = DoorRegistry.getMovement(nbt.func_74779_i("doorMovement"));
        this.doorSound = DoorRegistry.getSound(nbt.func_74779_i("doorSound"));
        this.openingTime = nbt.func_74762_e("openingTime");
        this.autoCloseTime = nbt.func_74762_e("autoCloseTime");
        this.redstoneBehavior = DoorDescriptor.RedstoneBehavior.values()[nbt.func_74762_e("redstoneBehavior")];
        this.doubleDoor = nbt.func_74767_n("doubleDoor");
        this.proximityDetection = nbt.func_74767_n("proximityDetection");
        this.inventory.readFromNBT(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private class DoorEditSlot
    extends MalisisSlot {
        private DoorEditSlot() {
        }

        public boolean isItemValid(ItemStack itemStack) {
            if (itemStack.func_77973_b() == MalisisDoors.Items.verticalHatchItem) {
                return false;
            }
            return itemStack.func_77973_b() instanceof DoorItem || itemStack.func_77973_b() instanceof ItemDoor;
        }
    }

    private class DoorFactorySlot
    extends MalisisSlot {
        private boolean forFrame;

        public DoorFactorySlot(boolean frame) {
            this.forFrame = frame;
        }

        public boolean isItemValid(ItemStack itemStack) {
            return CustomDoorItem.canBeUsedForDoor(itemStack, this.forFrame);
        }
    }
}

