/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.api.permission;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import omtteam.omlib.api.permission.EnumAccessLevel;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.util.DebugHandler;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.player.Player;
import omtteam.omlib.util.player.PlayerUtil;

public interface ITrustedPlayersManager
extends IHasOwner {
    @ParametersAreNonnullByDefault
    public boolean addTrustedPlayer(String var1);

    @Override
    public Player getOwner();

    default public boolean addTrustedPlayer(TrustedPlayer player) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if (!trustedPlayer.equals(player)) continue;
            return false;
        }
        if (GeneralUtil.isServerInOnlineMode() && player.getUuid() == null) {
            return false;
        }
        this.getTrustedPlayers().add(player);
        return true;
    }

    default public boolean removeTrustedPlayer(String name) {
        for (TrustedPlayer player : this.getTrustedPlayers()) {
            if (!player.getName().equals(name)) continue;
            this.getTrustedPlayers().remove(player);
            DebugHandler.getInstance().sendMessageToDebugChat("Sucessfully removed " + name + ".");
            return true;
        }
        DebugHandler.getInstance().sendMessageToDebugChat("Could not remove " + name + ".");
        return false;
    }

    default public TrustedPlayer getTrustedPlayer(String name) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if (!trustedPlayer.getName().equals(name)) continue;
            return trustedPlayer;
        }
        return null;
    }

    default public TrustedPlayer getTrustedPlayer(UUID uuid) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if (!trustedPlayer.getUuid().equals(uuid)) continue;
            return trustedPlayer;
        }
        return null;
    }

    default public TrustedPlayer getTrustedPlayer(Player player) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if ((GeneralUtil.isServerInOnlineMode() || !trustedPlayer.getName().equals(player.getName())) && (trustedPlayer.getUuid() == null || !trustedPlayer.getUuid().equals(player.getUuid()))) continue;
            return trustedPlayer;
        }
        return null;
    }

    public List<TrustedPlayer> getTrustedPlayers();

    public void setTrustedPlayers(List<TrustedPlayer> var1);

    default public List<Map<String, String>> getTrustedPlayersAsListMap() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (TrustedPlayer tp : this.getTrustedPlayers()) {
            list.add(tp.asMap());
        }
        return list;
    }

    default public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbtList = new NBTTagList();
        nbt.func_74757_a("useGlobal", this.useGlobal());
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            NBTTagCompound nbtPlayer = new NBTTagCompound();
            nbtPlayer.func_74778_a("name", trustedPlayer.getName());
            nbtPlayer.func_74768_a("accessLevel", trustedPlayer.getAccessLevel().ordinal());
            if (trustedPlayer.getUuid() != null) {
                nbtPlayer.func_74778_a("UUID", trustedPlayer.getUuid().toString());
            } else if (PlayerUtil.getPlayerUUID(trustedPlayer.getName()) != null) {
                nbtPlayer.func_74778_a("UUID", PlayerUtil.getPlayerUUID(trustedPlayer.getName()).toString());
            }
            nbtList.func_74742_a((NBTBase)nbtPlayer);
        }
        nbt.func_74782_a("trustedPlayers", (NBTBase)nbtList);
        return nbt;
    }

    default public void readFromNBT(NBTTagCompound tagCompound) {
        this.getTrustedPlayers().clear();
        this.setUseGlobal(tagCompound.func_74767_n("useGlobal"));
        NBTTagList list = tagCompound.func_150295_c("trustedPlayers", (int)tagCompound.func_74732_a());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (!list.func_150305_b(i).func_74779_i("name").equals("")) {
                NBTTagCompound nbtPlayer = list.func_150305_b(i);
                TrustedPlayer trustedPlayer = new TrustedPlayer(nbtPlayer.func_74779_i("name"));
                if (nbtPlayer.func_74764_b("accessLevel")) {
                    trustedPlayer.setAccessLevel(EnumAccessLevel.values()[nbtPlayer.func_74762_e("accessLevel")]);
                } else if (nbtPlayer.func_74764_b("admin") && nbtPlayer.func_74767_n("admin")) {
                    trustedPlayer.setAccessLevel(EnumAccessLevel.ADMIN);
                } else if (nbtPlayer.func_74764_b("canChangeTargeting") && nbtPlayer.func_74767_n("canChangeTargeting")) {
                    trustedPlayer.setAccessLevel(EnumAccessLevel.CHANGE_SETTINGS);
                } else if (nbtPlayer.func_74764_b("canOpenGUI") && nbtPlayer.func_74767_n("canOpenGUI")) {
                    trustedPlayer.setAccessLevel(EnumAccessLevel.OPEN_GUI);
                }
                if (nbtPlayer.func_74764_b("UUID")) {
                    trustedPlayer.setUuid(PlayerUtil.getPlayerUIDUnstable(nbtPlayer.func_74779_i("UUID")));
                } else {
                    trustedPlayer.setUuid(PlayerUtil.getPlayerUUID(trustedPlayer.getName()));
                }
                if (trustedPlayer.getUuid() == null) continue;
                this.getTrustedPlayers().add(trustedPlayer);
                continue;
            }
            if (!list.func_150305_b(i).func_74779_i("name").equals("")) continue;
            TrustedPlayer trustedPlayer = new TrustedPlayer(list.func_150307_f(i));
            Logger.getGlobal().info("found legacy trusted Player: " + list.func_150307_f(i));
            trustedPlayer.setUuid(PlayerUtil.getPlayerUUID(trustedPlayer.getName()));
            if (trustedPlayer.getUuid() == null) continue;
            this.getTrustedPlayers().add(trustedPlayer);
        }
    }

    default public void readFromByteBuf(ByteBuf buf) {
        ArrayList<TrustedPlayer> sharePlayerList = new ArrayList<TrustedPlayer>();
        int lengthOfPlayerList = buf.readInt();
        if (lengthOfPlayerList > 0) {
            for (int j = 0; j < lengthOfPlayerList; ++j) {
                TrustedPlayer player = new TrustedPlayer(Player.readFromByteBuf(buf));
                player.setAccessLevel(EnumAccessLevel.values()[buf.readInt()]);
                sharePlayerList.add(player);
            }
        }
        this.setTrustedPlayers(sharePlayerList);
    }

    default public void writeToByteBuf(ByteBuf buf) {
        buf.writeInt(this.getTrustedPlayers().size());
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            Player.writeToByteBuf(trustedPlayer.getPlayer(), buf);
            buf.writeInt(trustedPlayer.getAccessLevel().ordinal());
        }
    }

    default public boolean changePermission(String player, EnumAccessLevel level) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if (!trustedPlayer.getName().equalsIgnoreCase(player)) continue;
            trustedPlayer.setAccessLevel(level);
            return true;
        }
        return false;
    }

    default public boolean changePermission(String player, int change) {
        for (TrustedPlayer trustedPlayer : this.getTrustedPlayers()) {
            if (!trustedPlayer.getName().equalsIgnoreCase(player)) continue;
            if (trustedPlayer.getAccessLevel().ordinal() == 0 && change == -1 || trustedPlayer.getAccessLevel().ordinal() == 3 && change == 1) {
                return false;
            }
            trustedPlayer.setAccessLevel(EnumAccessLevel.values()[trustedPlayer.getAccessLevel().ordinal() + change]);
            return true;
        }
        return false;
    }

    public boolean useGlobal();

    public void setUseGlobal(boolean var1);

    public boolean hasTile();

    public TileEntity getTile();
}

