/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.energy.tile.IHeatSource;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import trinsdar.ic2c_extras.container.ContainerElectricHeatGenerator;
import trinsdar.ic2c_extras.util.Registry;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;

public class TileEntityElectricHeatGenerator
extends TileEntityElecMachine
implements IHeatSource,
ITickable,
IHasGui {
    @NetworkField(index=7)
    public int heat;
    @NetworkField(index=8)
    public int maxHeat = 0;
    private int coilCount = 0;

    public TileEntityElectricHeatGenerator() {
        super(11, 128);
        this.maxEnergy = 10000;
        this.setFuelSlot(10);
        this.addNetworkFields(new String[]{"heat", "maxHeat"});
        this.addGuiFields(new String[]{"heat", "maxHeat"});
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.ELECTRIC_HEAT_GENERATOR;
    }

    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{10});
        handler.registerInputFilter((IFilter)new ArrayFilter(new IFilter[]{CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)}), new int[]{10});
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, new int[]{10});
        handler.registerSlotType(SlotType.Fuel, new int[]{10});
    }

    public int maxrequestHeatTick(EnumFacing enumFacing) {
        return enumFacing == null || enumFacing == this.getFacing() ? this.maxHeat : 0;
    }

    public int requestHeat(EnumFacing enumFacing, int i) {
        return this.drawHeat(enumFacing, i, false);
    }

    public int drawHeat(EnumFacing side, int request, boolean simulate) {
        if ((side == null && simulate || side != null && side == this.getFacing()) && request <= this.maxrequestHeatTick(side)) {
            int drawn = Math.min(this.heat, request);
            if (!simulate) {
                this.heat -= drawn;
            }
            return drawn;
        }
        return 0;
    }

    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        this.handleChargeSlot(this.maxEnergy);
        int oldMaxHeat = this.maxHeat;
        this.maxHeat = this.coilCount * 10;
        if (oldMaxHeat != this.maxHeat) {
            this.getNetwork().updateTileGuiField((TileEntity)this, "maxHeat");
        }
        if (this.energy > 0 && this.maxHeat > 0 && this.heat < this.maxHeat) {
            int room = this.maxHeat - this.heat;
            int made = Math.min(room, this.energy);
            this.heat += made;
            this.getNetwork().updateTileGuiField((TileEntity)this, "heat");
            this.energy -= made;
            if (!this.isActive) {
                this.setActive(true);
            }
        } else if (this.isActive) {
            this.setActive(false);
        }
    }

    public int getMaxStackSize(int slot) {
        if (slot < 10) {
            return 1;
        }
        return super.getMaxStackSize(slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.coilCount = 0;
        for (int i = 0; i < 10; ++i) {
            if (this.getStackInSlot(i).func_77973_b() != Registry.coil) continue;
            ++this.coilCount;
        }
    }

    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("heat");
        this.maxHeat = nbt.func_74762_e("maxHeat");
        this.coilCount = nbt.func_74762_e("coilCount");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("maxHeat", this.maxHeat);
        nbt.func_74768_a("coilCount", this.coilCount);
        return nbt;
    }

    public void setFacing(EnumFacing face) {
        super.setFacing(face);
        this.updateConnections();
    }

    public void updateConnections() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos sidedPos = this.field_174879_c.func_177972_a(facing);
            if (!this.field_145850_b.func_175667_e(sidedPos)) continue;
            this.field_145850_b.func_190524_a(sidedPos, Blocks.field_150350_a, this.field_174879_c);
        }
        if (this.field_145850_b.func_175667_e(this.field_174879_c)) {
            this.field_145850_b.func_190524_a(this.field_174879_c, Blocks.field_150350_a, this.field_174879_c);
        }
    }

    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricHeatGenerator(entityPlayer.field_71071_by, this);
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer entityPlayer) {
        return GuiComponentContainer.class;
    }

    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return !this.func_145837_r();
    }

    public boolean hasGui(EntityPlayer entityPlayer) {
        return true;
    }
}

