/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.scoreboard;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.ResettableBuilder;

public interface Scoreboard {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public Optional<Objective> getObjective(String var1);

    public Optional<Objective> getObjective(DisplaySlot var1);

    public void addObjective(Objective var1) throws IllegalArgumentException;

    public void updateDisplaySlot(@Nullable Objective var1, DisplaySlot var2) throws IllegalStateException;

    default public void clearSlot(DisplaySlot slot) {
        this.updateDisplaySlot(null, slot);
    }

    public Set<Objective> getObjectivesByCriteria(Criterion var1);

    public Set<Objective> getObjectives();

    public void removeObjective(Objective var1);

    public Set<Score> getScores();

    public Set<Score> getScores(Text var1);

    public void removeScores(Text var1);

    public Optional<Team> getTeam(String var1);

    public void registerTeam(Team var1) throws IllegalArgumentException;

    public Set<Team> getTeams();

    public Optional<Team> getMemberTeam(Text var1);

    public static interface Builder
    extends ResettableBuilder<Scoreboard, Builder> {
        public Builder objectives(List<Objective> var1);

        public Builder teams(List<Team> var1);

        public Scoreboard build() throws IllegalStateException;
    }
}

