/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.bridge.entity.LivingEntityBaseBridge;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.registry.type.event.DamageSourceRegistryModule;
import org.spongepowered.common.util.Constants;

public class HealthValueProcessor
extends AbstractSpongeValueProcessor<EntityLivingBase, Double, MutableBoundedValue<Double>> {
    public HealthValueProcessor() {
        super(EntityLivingBase.class, Keys.HEALTH);
    }

    @Override
    public MutableBoundedValue<Double> constructValue(Double health) {
        return SpongeValueFactory.boundedBuilder(Keys.HEALTH).comparator(Constants.Functional.doubleComparator()).minimum(0.0).maximum(Float.valueOf(Float.MAX_VALUE).doubleValue()).defaultValue(20.0).actualValue(health).build();
    }

    @Override
    protected boolean set(EntityLivingBase container, Double value) {
        return false;
    }

    @Override
    protected Optional<Double> getVal(EntityLivingBase container) {
        return Optional.of(Double.valueOf(container.func_110143_aJ()));
    }

    @Override
    protected ImmutableBoundedValue<Double> constructImmutableValue(Double value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public Optional<MutableBoundedValue<Double>> getApiValueFromContainer(ValueContainer<?> container) {
        if (container instanceof EntityLivingBase) {
            double health = ((EntityLivingBase)container).func_110143_aJ();
            double maxHealth = ((EntityLivingBase)container).func_110138_aP();
            return Optional.of(SpongeValueFactory.boundedBuilder(Keys.HEALTH).minimum(0.0).maximum(maxHealth).defaultValue(maxHealth).actualValue(health).build());
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(ValueContainer<?> container) {
        return container instanceof EntityLivingBase;
    }

    @Override
    public DataTransactionResult offerToStore(ValueContainer<?> container, Double value) {
        ImmutableBoundedValue<Double> proposedValue = this.constructImmutableValue(value);
        if (container instanceof EntityLivingBase) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            EntityLivingBase livingbase = (EntityLivingBase)container;
            double maxHealth = livingbase.func_110138_aP();
            ImmutableValue newHealthValue = SpongeValueFactory.boundedBuilder(Keys.HEALTH).defaultValue(maxHealth).minimum(0.0).maximum(maxHealth).actualValue(value).build().asImmutable();
            ImmutableValue oldHealthValue = this.getApiValueFromContainer(container).get().asImmutable();
            if (value > maxHealth) {
                return DataTransactionResult.errorResult(newHealthValue);
            }
            try {
                livingbase.func_70606_j(value.floatValue());
            }
            catch (Exception e) {
                return DataTransactionResult.errorResult(newHealthValue);
            }
            if (value.floatValue() <= 0.0f) {
                livingbase.func_70097_a(DamageSourceRegistryModule.IGNORED_DAMAGE_SOURCE, 1000.0f);
            } else {
                ((LivingEntityBaseBridge)livingbase).bridge$resetDeathEventsPosted();
            }
            return builder.success(newHealthValue).replace(oldHealthValue).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failResult(proposedValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

