/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.world.ExplosionEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.ExplosionBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.CaptureBlockPos;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin
implements ExplosionBridge {
    private boolean impl$shouldBreakBlocks;
    private boolean impl$shouldDamageEntities;
    private int impl$resolution;
    private float impl$randomness;
    private double impl$knockback;
    @Shadow
    @Final
    private List<BlockPos> field_77281_g;
    @Shadow
    @Final
    private Map<EntityPlayer, Vec3d> field_77288_k;
    @Shadow
    @Final
    private Random field_77290_i;
    @Shadow
    @Final
    private boolean field_77286_a;
    @Shadow
    @Final
    private boolean field_82755_b;
    @Shadow
    @Final
    private net.minecraft.world.World field_77287_j;
    @Shadow
    @Final
    private double field_77284_b;
    @Shadow
    @Final
    private double field_77285_c;
    @Shadow
    @Final
    private double field_77282_d;
    @Shadow
    @Final
    private net.minecraft.entity.Entity field_77283_e;
    @Shadow
    @Final
    private float field_77280_f;

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(net.minecraft.world.World world, net.minecraft.entity.Entity entity, double originX, double originY, double originZ, float radius, boolean isFlaming, boolean isSmoking, CallbackInfo ci) {
        this.impl$shouldBreakBlocks = this.field_82755_b;
        this.impl$shouldDamageEntities = true;
        this.impl$resolution = 16;
        this.impl$randomness = 1.0f;
        this.impl$knockback = 1.0;
    }

    @Overwrite
    public void func_77278_a() {
        List list;
        if (this.impl$shouldBreakBlocks) {
            HashSet set = Sets.newHashSet();
            for (int j = 0; j < this.impl$resolution; ++j) {
                for (int k = 0; k < this.impl$resolution; ++k) {
                    for (int l = 0; l < this.impl$resolution; ++l) {
                        if (j != 0 && j != this.impl$resolution - 1 && k != 0 && k != this.impl$resolution - 1 && l != 0 && l != this.impl$resolution - 1) continue;
                        double d0 = (float)j / (float)(this.impl$resolution - 1) * 2.0f - 1.0f;
                        double d1 = (float)k / (float)(this.impl$resolution - 1) * 2.0f - 1.0f;
                        double d2 = (float)l / (float)(this.impl$resolution - 1) * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.field_77284_b;
                        double d6 = this.field_77285_c;
                        double d8 = this.field_77282_d;
                        float f1 = 0.3f;
                        for (float f = this.field_77280_f * (1.0f + (this.field_77287_j.field_73012_v.nextFloat() * 0.6f - 0.3f) * this.impl$randomness); f > 0.0f; f -= 0.22500001f) {
                            BlockPos blockpos = new BlockPos(d4, d6, d8);
                            IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                                float f2 = this.field_77283_e != null ? this.field_77283_e.func_180428_a((Explosion)this, this.field_77287_j, blockpos, iblockstate) : iblockstate.func_177230_c().func_149638_a((net.minecraft.entity.Entity)null);
                                f -= (f2 + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && (this.field_77283_e == null || this.field_77283_e.func_174816_a((Explosion)this, this.field_77287_j, blockpos, iblockstate, f))) {
                                set.add(blockpos);
                            }
                            d4 += d0 * (double)0.3f;
                            d6 += d1 * (double)0.3f;
                            d8 += d2 * (double)0.3f;
                        }
                    }
                }
            }
            this.field_77281_g.addAll(set);
        }
        float f3 = this.field_77280_f * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.field_77284_b - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77284_b + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)f3 + 1.0));
        List list2 = list = this.impl$shouldDamageEntities ? this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1)) : Collections.emptyList();
        if (ShouldFire.EXPLOSION_EVENT_DETONATE) {
            ArrayList<Location<World>> blockPositions = new ArrayList<Location<World>>(this.field_77281_g.size());
            ArrayList<Entity> entities = new ArrayList<Entity>(list.size());
            for (BlockPos pos : this.field_77281_g) {
                blockPositions.add(new Location<World>((World)this.field_77287_j, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            }
            for (net.minecraft.entity.Entity entity : list) {
                if (entity.func_180427_aV()) continue;
                entities.add((Entity)entity);
            }
            Cause cause = Sponge.getCauseStackManager().getCurrentCause();
            ExplosionEvent.Detonate detonate = SpongeEventFactory.createExplosionEventDetonate(cause, blockPositions, entities, (org.spongepowered.api.world.explosion.Explosion)((Object)this), (World)this.field_77287_j);
            SpongeImpl.postEvent(detonate);
            this.field_77281_g.clear();
            if (detonate.isCancelled()) {
                return;
            }
            if (this.impl$shouldBreakBlocks) {
                for (Location<World> worldLocation : detonate.getAffectedLocations()) {
                    this.field_77281_g.add(VecHelper.toBlockPos(worldLocation));
                }
            }
            list.clear();
            if (this.impl$shouldDamageEntities) {
                for (Entity entity : detonate.getEntities()) {
                    try {
                        list.add((net.minecraft.entity.Entity)entity);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        Vec3d vec3d = new Vec3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            EntityPlayer entityplayer;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.field_77284_b, this.field_77285_c, this.field_77282_d) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.field_77284_b) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.field_77285_c) * d7 + (d9 = entity.field_70161_v - this.field_77282_d) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = this.field_77287_j.func_72842_a(vec3d, entity.func_174813_aQ());
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(DamageSource.func_94539_a((Explosion)((Explosion)this)), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = 1.0;
            if (entity instanceof EntityLivingBase) {
                d11 = EnchantmentProtection.func_92092_a((EntityLivingBase)((EntityLivingBase)entity), (double)d10);
            }
            entity.field_70159_w += d5 * d11 * this.impl$knockback;
            entity.field_70181_x += d7 * d11 * this.impl$knockback;
            entity.field_70179_y += d9 * d11 * this.impl$knockback;
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v() || entityplayer.func_184812_l_() && entityplayer.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(entityplayer, new Vec3d(d5 * d10 * this.impl$knockback, d7 * d10 * this.impl$knockback, d9 * d10 * this.impl$knockback));
        }
    }

    @Overwrite
    public void func_77279_a(boolean spawnParticles) {
        boolean hasCapturePos;
        this.field_77287_j.func_184148_a((EntityPlayer)null, this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.field_77280_f >= 2.0f && (this.field_82755_b || this.impl$shouldBreakBlocks)) {
            if (this.field_77287_j instanceof WorldServer) {
                ((WorldServer)this.field_77287_j).func_175739_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1, 0.0, 0.0, 0.0, 0.1, new int[0]);
            } else {
                this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
            }
        } else if (this.field_77287_j instanceof WorldServer) {
            ((WorldServer)this.field_77287_j).func_175739_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1, 0.0, 0.0, 0.0, 0.1, new int[0]);
        } else {
            this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0, new int[0]);
        }
        PhaseContext<?> context = !((WorldBridge)this.field_77287_j).bridge$isFake() ? PhaseTracker.getInstance().getCurrentContext() : null;
        boolean bl = hasCapturePos = context != null && context.state.requiresBlockPosTracking();
        if (this.impl$shouldBreakBlocks) {
            for (BlockPos blockpos : this.field_77281_g) {
                Throwable throwable;
                CaptureBlockPos pos;
                IBlockState iblockstate = this.field_77287_j.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockpos.func_177958_n() + this.field_77287_j.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.field_77287_j.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.field_77287_j.field_73012_v.nextFloat();
                    double d3 = d0 - this.field_77284_b;
                    double d4 = d1 - this.field_77285_c;
                    double d5 = d2 - this.field_77282_d;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
                    this.field_77287_j.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.field_77284_b) / 2.0, (d1 + this.field_77285_c) / 2.0, (d2 + this.field_77282_d) / 2.0, d3 *= (d7 *= (double)(this.field_77287_j.field_73012_v.nextFloat() * this.field_77287_j.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.field_77287_j.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    pos = hasCapturePos ? context.getCaptureBlockPos() : null;
                    throwable = null;
                    try {
                        if (pos != null) {
                            pos.setPos(blockpos);
                        }
                        block.func_180653_a(this.field_77287_j, blockpos, this.field_77287_j.func_180495_p(blockpos), 1.0f / this.field_77280_f, 0);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (pos != null) {
                            if (throwable != null) {
                                try {
                                    pos.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                pos.close();
                            }
                        }
                    }
                }
                pos = hasCapturePos ? context.getCaptureBlockPos() : null;
                throwable = null;
                try {
                    if (pos != null) {
                        pos.setPos(blockpos);
                    }
                    SpongeImplHooks.blockExploded(block, this.field_77287_j, blockpos, (Explosion)this);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (pos == null) continue;
                    if (throwable != null) {
                        try {
                            pos.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    pos.close();
                }
            }
        }
        if (this.field_77286_a) {
            for (BlockPos blockpos1 : this.field_77281_g) {
                if (this.field_77287_j.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.field_77287_j.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.field_77290_i.nextInt(3) != 0) continue;
                CaptureBlockPos pos = hasCapturePos ? context.getCaptureBlockPos() : null;
                Throwable throwable = null;
                try {
                    if (pos != null) {
                        pos.setPos(blockpos1);
                    }
                    this.field_77287_j.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (pos == null) continue;
                    if (throwable != null) {
                        try {
                            pos.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    pos.close();
                }
            }
        }
    }

    @Override
    public boolean bridge$getShouldDamageBlocks() {
        return this.impl$shouldBreakBlocks;
    }

    @Override
    public boolean bridge$getShouldDamageEntities() {
        return this.impl$shouldDamageEntities;
    }

    @Override
    public void bridge$setShouldBreakBlocks(boolean shouldBreakBlocks) {
        this.impl$shouldBreakBlocks = shouldBreakBlocks;
    }

    @Override
    public void bridge$setShouldDamageEntities(boolean shouldDamageEntities) {
        this.impl$shouldDamageEntities = shouldDamageEntities;
    }

    @Override
    public void bridge$setResolution(int resolution) {
        this.impl$resolution = resolution;
    }

    @Override
    public int bridge$getResolution() {
        return this.impl$resolution;
    }

    @Override
    public void bridge$setRandomness(float randomness) {
        this.impl$randomness = randomness;
    }

    @Override
    public float bridge$getRandomness() {
        return this.impl$randomness;
    }

    @Override
    public void bridge$setKnockback(double knockback) {
        this.impl$knockback = knockback;
    }

    @Override
    public double bridge$getKnockback() {
        return this.impl$knockback;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("causesFire", this.field_77286_a).add("damagesTerrain", this.field_82755_b).add("world", (Object)(this.field_77287_j.func_72912_H() == null ? "null" : this.field_77287_j.func_72912_H().func_76065_j())).add("x", this.field_77284_b).add("y", this.field_77285_c).add("z", this.field_77282_d).add("exploder", (Object)this.field_77283_e).add("size", this.field_77280_f).add("resolution", this.impl$resolution).add("randomness", this.impl$randomness).add("knockback", this.impl$knockback).toString();
    }
}

