/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class GuiMekanism
extends GuiContainer
implements IGuiWrapper {
    private Set<GuiElement> guiElements = new HashSet<GuiElement>();

    public GuiMekanism(Container container) {
        super(container);
    }

    public static boolean isTextboxKey(char c, int i) {
        return i == 14 || i == 211 || i == 203 || i == 205 || i == 207 || i == 199 || GuiMekanism.func_175278_g((int)i) || GuiMekanism.func_175280_f((int)i) || GuiMekanism.func_175279_e((int)i) || GuiMekanism.func_175277_d((int)i);
    }

    public Set<GuiElement> getGuiElements() {
        return this.guiElements;
    }

    protected float getNeededScale(String text, int maxX) {
        int length = this.field_146289_q.func_78256_a(text);
        return length <= maxX ? 1.0f : (float)maxX / (float)length;
    }

    protected void addGuiElement(GuiElement element) {
        this.guiElements.add(element);
    }

    public void renderScaledText(String text, int x, int y, int color, int maxX) {
        int length = this.field_146289_q.func_78256_a(text);
        if (length <= maxX) {
            this.field_146289_q.func_78276_b(text, x, y, color);
        } else {
            float scale = (float)maxX / (float)length;
            float reverse = 1.0f / scale;
            float yAdd = 4.0f - scale * 8.0f / 2.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.field_146289_q.func_78276_b(text, (int)((float)x * reverse), (int)((float)y * reverse + yAdd), color);
            GlStateManager.func_179121_F();
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.guiElements.forEach(element -> element.renderForeground(xAxis, yAxis));
    }

    protected boolean func_146981_a(Slot slot, int mouseX, int mouseY) {
        return this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        this.guiElements.forEach(element -> element.renderBackground(xAxis, yAxis, guiWidth, guiHeight));
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.guiElements.forEach(element -> element.preMouseClicked(xAxis, yAxis, button));
        super.func_73864_a(mouseX, mouseY, button);
        this.guiElements.forEach(element -> element.mouseClicked(xAxis, yAxis, button));
    }

    @Override
    public void drawTexturedRect(int x, int y, int u, int v, int w, int h) {
        this.func_73729_b(x, y, u, v, w, h);
    }

    @Override
    public void drawTexturedRectFromIcon(int x, int y, TextureAtlasSprite icon, int w, int h) {
        this.func_175175_a(x, y, icon, w, h);
    }

    @Override
    public void displayTooltip(String s, int x, int y) {
        this.func_146279_a(s, x, y);
    }

    @Override
    public void displayTooltips(List<String> list, int xAxis, int yAxis) {
        this.func_146283_a(list, xAxis, yAxis);
    }

    @Override
    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.guiElements.forEach(element -> element.mouseClickMove(xAxis, yAxis, button, ticks));
    }

    protected void func_146286_b(int mouseX, int mouseY, int type) {
        super.func_146286_b(mouseX, mouseY, type);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.guiElements.forEach(element -> element.mouseReleased(xAxis, yAxis, type));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            int xAxis = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.getXPos();
            int yAxis = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.getYPos();
            this.mouseWheel(xAxis, yAxis, delta);
        }
    }

    public void mouseWheel(int xAxis, int yAxis, int delta) {
        this.guiElements.forEach(element -> element.mouseWheel(xAxis, yAxis, delta));
    }

    public int getXPos() {
        return (this.field_146294_l - this.field_146999_f) / 2;
    }

    public int getYPos() {
        return (this.field_146295_m - this.field_147000_g) / 2;
    }

    protected FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void renderCenteredText(int leftMargin, int areaWidth, int y, int color, String text) {
        int textWidth = this.field_146289_q.func_78256_a(text);
        int centerX = leftMargin + areaWidth / 2 - textWidth / 2;
        this.field_146289_q.func_78276_b(text, centerX, y, color);
    }

    protected abstract ResourceLocation getGuiLocation();
}

