/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockConnectedTexture;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockClearStainedGlass
extends EnumBlockConnectedTexture<EnumGlassColor> {
    public static final PropertyEnum<EnumGlassColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumGlassColor.class);

    public BlockClearStainedGlass() {
        super(Material.field_151592_s, COLOR, EnumGlassColor.class);
        this.func_149711_c(0.3f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabGeneral);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumGlassColor)((Object)state.func_177229_b(COLOR))).getMapColor();
    }

    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return !this.canConnect(blockState, blockAccess.func_180495_p(pos.func_177972_a(side))) && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        if (state.func_177228_b().containsKey(COLOR)) {
            EnumGlassColor color = (EnumGlassColor)((Object)state.func_177229_b(COLOR));
            return color.rgb;
        }
        return null;
    }

    public static enum EnumGlassColor implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        WHITE(0xFFFFFF, MapColor.field_151666_j),
        ORANGE(14188339, MapColor.field_151676_q),
        MAGENTA(11685080, MapColor.field_151675_r),
        LIGHT_BLUE(6724056, MapColor.field_151674_s),
        YELLOW(0xE5E533, MapColor.field_151673_t),
        LIME(8375321, MapColor.field_151672_u),
        PINK(15892389, MapColor.field_151671_v),
        GRAY(0x4C4C4C, MapColor.field_151670_w),
        SILVER(0x999999, MapColor.field_151680_x),
        CYAN(5013401, MapColor.field_151679_y),
        PURPLE(8339378, MapColor.field_151678_z),
        BLUE(3361970, MapColor.field_151649_A),
        BROWN(6704179, MapColor.field_151650_B),
        GREEN(6717235, MapColor.field_151651_C),
        RED(0x993333, MapColor.field_151645_D),
        BLACK(0x191919, MapColor.field_151646_E);

        private final int color;
        private final MapColor mapColor;
        private final int meta = this.ordinal();
        private final float[] rgb;

        private EnumGlassColor(int color, MapColor mapColor) {
            this.color = color;
            this.mapColor = mapColor;
            this.rgb = EnumGlassColor.calcRGB(color);
        }

        private static float[] calcRGB(int color) {
            float[] out = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            return out;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getColor() {
            return this.color;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }
    }
}

