/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.info;

import ic2.api.classic.tile.IInfoTile;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.core.block.base.util.info.misc.IProbeComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;

public class ReactorChamberInfo
implements IProbeComponent {
    IReactorChamber chamber;

    public ReactorChamberInfo(IReactorChamber reactor) {
        this.chamber = reactor;
    }

    @Override
    public String getDisplayText(EntityPlayer player) {
        int max = 0;
        int min = 0;
        IReactor reactor = this.chamber.getReactorInstance();
        if (reactor != null) {
            min = reactor.getHeat();
            max = reactor.getMaxHeat();
        }
        return Ic2InfoLang.reactorHeat.getLocalizedFormatted(min, max);
    }

    @Override
    public boolean canShow(EntityPlayer player) {
        return PlayerHandler.getClientPlayerHandler().hasThermometer();
    }

    @Override
    public IInfoTile.InfoType getType() {
        return IInfoTile.InfoType.Custom;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public boolean isModeValid(ProbeMode mode, PlayerHandler handler) {
        return mode != ProbeMode.NORMAL && handler.hasThermometer();
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void applyInfo(IProbeInfo info, EntityPlayer player, EnumFacing side) {
        IReactor reactor = this.chamber.getReactorInstance();
        if (reactor == null) {
            info.progress(0, 0, info.defaultProgressStyle().prefix("Heat: "));
            return;
        }
        info.progress(reactor.getHeat(), reactor.getMaxHeat(), info.defaultProgressStyle().prefix("Heat: "));
    }
}

