/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.personalBlocks;

import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.core.IC2;
import ic2.core.block.personal.base.util.TradeSyncer;
import ic2.core.block.personal.container.ContainerEnergyOMatClosed;
import ic2.core.block.personal.tile.TileEntityEnergyOMat;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.IconButton;
import ic2.core.inventory.gui.buttons.ToggleButton;
import ic2.core.inventory.gui.buttons.ToolTipButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyOMatClosedComp
extends GuiComponent {
    public static final ItemStack cancelIcon = Ic2Items.displayIcons[1].func_77946_l();
    public static final ItemStack okIcon = Ic2Items.displayIcons[0].func_77946_l();
    int tradeAmount = 1;
    boolean showFakeItems = true;
    TileEntityEnergyOMat trade;
    TradeSyncer.ClientEntry clientData;
    List<String> textToShow = new LinkedList<String>();
    boolean showText = false;
    int ticks = 0;

    public EnergyOMatClosedComp(TileEntityEnergyOMat tile) {
        super(Ic2GuiComp.nullBox);
        this.trade = tile;
        this.clientData = this.trade.getSyncer().getClientData();
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.PostDraw, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        List<LocaleComp> list = Arrays.asList(Ic2GuiLang.getCtrlKey("1000"), Ic2GuiLang.getShiftKey("100"), Ic2GuiLang.getAltKey("10"));
        gui.registerButton(new IC2Button(0, x + 25, y + 15, 8, 10, "<"));
        gui.registerButton(new IC2Button(1, x + 52, y + 15, 8, 10, ">"));
        gui.registerButton(new IC2Button(2, x + 12, y + 27, 10, 20, "<"));
        gui.registerButton(new IC2Button(3, x + 155, y + 27, 10, 20, ">"));
        gui.registerButton(new ToggleButton(4, x + 90, y + 27, 20, 20).setIcons(cancelIcon, okIcon).addToolTip(Ic2GuiLang.tradeShowItems).setState(this.showFakeItems));
        gui.registerButton(new IconButton(5, x + 65, y + 27, 20, 20).setItemStack(new ItemStack(Items.field_151121_aF)).addText(Ic2GuiLang.tradeButton));
        gui.registerButton(new IconButton(6, x + 90, y + 50, 20, 20).setItemStack(new ItemStack(Items.field_151057_cb)).addText(Ic2GuiLang.tradeRequirements));
        gui.registerButton(new IconButton(7, x + 65, y + 50, 20, 20).setItemStack(new ItemStack(Items.field_151122_aG)).addText(Ic2GuiLang.tradeCustomInfo));
        gui.registerButton(new ToolTipButton(8, x - 68, y + 125, 30, 12, "-").addComponents(list));
        gui.registerButton(new ToolTipButton(9, x - 35, y + 125, 30, 12, "+").addComponents(list));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id;
        UUID playerID = gui.getPlayerID();
        ContainerEnergyOMatClosed cont = gui.getContainer(ContainerEnergyOMatClosed.class);
        if (this.showText) {
            this.ticks = 0;
            this.textToShow.clear();
        }
        if ((id = button.field_146127_k) == 0) {
            if (this.clientData.canMoveSubTrade(false)) {
                this.clientData.moveSubTrade(false);
                cont.lastStockCount = -1;
            }
        } else if (id == 1) {
            if (this.clientData.canMoveSubTrade(true)) {
                this.clientData.moveSubTrade(true);
                cont.lastStockCount = -1;
            }
        } else if (id == 2) {
            if (this.clientData.canMoveTrade(false)) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 0);
                cont.lastStockCount = -1;
            }
        } else if (id == 3) {
            if (this.clientData.canMoveTrade(true)) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 1);
                cont.lastStockCount = -1;
            }
        } else if (id == 4) {
            this.showFakeItems = !this.showFakeItems;
            cont.changeState(this.showFakeItems);
        } else if (id == 5) {
            ISubTrade sub = this.clientData.getSubTrade();
            if (sub != null && sub.getTrade().canAccessTrade(playerID) && sub.canPerformTrade(playerID)) {
                PayloadFieldPacket packet = new PayloadFieldPacket(0, 2, 0);
                packet.addNumber(0, sub.getTrade().getTradeSlot(sub));
                packet.addNumber(1, this.tradeAmount);
                IC2.network.get().initiateCustomClientTileEntityEvent(this.trade, packet);
                cont.lastStockCount = -1;
            } else {
                IC2.platform.messagePlayer(gui.getPlayer(), Ic2GuiLang.tradeNotPresent);
            }
        } else if (id == 6) {
            ISubTrade sub;
            if (!this.showText && (sub = this.clientData.getSubTrade()) != null && sub.getTrade().canAccessTrade(playerID) && sub.canPerformTrade(playerID)) {
                LinkedHashMap<ItemStack, Integer> input = new LinkedHashMap<ItemStack, Integer>();
                int totalEnergy = 0;
                for (ItemStack stack : sub.getRequiredItems(playerID)) {
                    this.addToMap(input, stack);
                }
                ITrade energyTrade = sub.getTrade();
                for (Integer n : energyTrade.getTradeResults(sub)) {
                    totalEnergy += n.intValue();
                }
                this.textToShow.add(Ic2GuiLang.tradeNeeds.getLocalized());
                for (Map.Entry entry : input.entrySet()) {
                    ItemStack key = (ItemStack)entry.getKey();
                    if (key == null) continue;
                    this.textToShow.add(Ic2GuiLang.tradeNeedsEntry.getLocalizedFormatted(key.func_82833_r(), entry.getValue()));
                }
                this.textToShow.add("");
                this.textToShow.add(Ic2GuiLang.tradeProvided.getLocalized());
                this.textToShow.add(Ic2GuiLang.eu.getLocalizedFormatted(totalEnergy));
                this.showText = true;
                this.ticks = 200;
            }
        } else if (id == 7) {
            ISubTrade sub;
            if (!this.showText && (sub = this.clientData.getSubTrade()) != null) {
                List<String> list = sub.getToolTip();
                if (list != null && list.size() > 0) {
                    this.textToShow.addAll(list);
                } else {
                    this.textToShow.add(Ic2GuiLang.tradeNothing.getLocalized());
                }
                this.showText = true;
                this.ticks = 200;
            }
        } else if (id == 8 || id == 9) {
            int value = this.getButtonNumber();
            if (id == 8) {
                value = -value;
            }
            this.tradeAmount = Math.min(Short.MAX_VALUE, Math.max(1, this.tradeAmount + value));
        }
        if (this.showText && this.ticks == 0) {
            this.showText = false;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        gui.getButton((int)0).field_146124_l = this.clientData.canMoveSubTrade(false);
        gui.getButton((int)1).field_146124_l = this.clientData.canMoveSubTrade(true);
        gui.getButton((int)2).field_146124_l = this.clientData.canMoveTrade(false);
        gui.getButton((int)3).field_146124_l = this.clientData.canMoveTrade(true);
        gui.getCastedButton(4, ToggleButton.class).setState(this.showFakeItems);
        gui.getButton((int)8).field_146124_l = this.tradeAmount > 1;
        gui.getButton((int)9).field_146124_l = this.tradeAmount < Short.MAX_VALUE;
        ContainerEnergyOMatClosed cont = gui.getContainer(ContainerEnergyOMatClosed.class);
        cont.setDrawing(true);
        cont.clearDisplay();
        if (this.clientData.focus == null) {
            return;
        }
        ISubTrade sub = this.clientData.getSubTrade();
        if (sub == null || !this.showFakeItems) {
            return;
        }
        UUID player = gui.getPlayerID();
        int slot = 0;
        List<ItemStack> list = sub.isMoneyTrade() ? this.trade.generateCoins(sub.getNeededMoney()) : sub.getRequiredItems(player);
        for (ItemStack stack : list) {
            cont.setItemIntoLayer(slot, stack);
            if (++slot <= 7) continue;
            break;
        }
        slot = 0;
        this.trade.currentEnergy.reset();
        for (Integer energy : sub.getTrade().getTradeResults(sub)) {
            this.trade.currentEnergy.increase(energy);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postDraw(GuiIC2 gui, int mouseX, int mouseY) {
        gui.getContainer(ContainerEnergyOMatClosed.class).setDrawing(false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (!this.showText) {
            if (this.textToShow.size() > 0) {
                this.textToShow.clear();
            }
            return;
        }
        if (--this.ticks <= 0) {
            this.textToShow.clear();
            this.showText = false;
            return;
        }
        tooltips.addAll(this.textToShow);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        gui.drawString(Ic2GuiLang.tradeStock, -69, 53, 0x404040);
        gui.drawString("" + this.getStock(gui), -69, 63, 0x404040);
        gui.drawString(Ic2GuiLang.tradeCount, -69, 103, 0x404040);
        gui.drawString("" + this.tradeAmount, -69, 113, 0x404040);
        gui.drawString(Ic2GuiLang.tradeEnergyProvided, 180, 53, 0x404040);
        gui.drawString("" + this.trade.currentEnergy.getValue(), 180, 63, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.func_73729_b(x - 73, y + 50, 0, 192, 73, 43);
        gui.func_73729_b(x - 73, y + 100, 0, 192, 73, 43);
    }

    @SideOnly(value=Side.CLIENT)
    public int getStock(GuiIC2 gui) {
        ContainerEnergyOMatClosed cont = gui.getContainer(ContainerEnergyOMatClosed.class);
        if (cont.lastStockCount == -1) {
            UUID id = gui.getPlayerID();
            cont.lastStockCount = 0;
            ISubTrade sub = this.clientData.getSubTrade();
            if (sub != null && sub.getTrade().canAccessTrade(id) && sub.canPerformTrade(id)) {
                PayloadFieldPacket packet = new PayloadFieldPacket(0, 1, 0);
                packet.addNumber(0, sub.getTrade().getTradeSlot(sub));
                this.trade.getNetwork().initiateCustomClientTileEntityEvent(this.trade, packet);
            }
        }
        return cont.stockCount;
    }

    private void addToMap(Map<ItemStack, Integer> map, ItemStack compare) {
        if (compare == null) {
            return;
        }
        for (Map.Entry<ItemStack, Integer> entry : map.entrySet()) {
            ItemStack stack = entry.getKey();
            if (!StackUtil.isStackEqual(stack, compare, false, false)) continue;
            entry.setValue(entry.getValue() + compare.func_190916_E());
            return;
        }
        map.put(compare, compare.func_190916_E());
    }

    @SideOnly(value=Side.CLIENT)
    public int getButtonNumber() {
        if (GuiScreen.func_146271_m()) {
            return 1000;
        }
        if (GuiScreen.func_146272_n()) {
            return 100;
        }
        if (GuiScreen.func_175283_s()) {
            return 10;
        }
        return 1;
    }
}

