/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import ic2.core.IC2;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.util.math.Box2D;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class ReactorPlannerPageBaseComp
extends GuiComponent {
    public static DecimalFormat floatFormat = Ic2Formatters.floatFormat;
    public static final DecimalFormat format = Ic2Formatters.bigFormat;
    public TileEntityReactorPlanner planner;
    int page;
    ItemStack stack;

    public ReactorPlannerPageBaseComp(Box2D box, int yourPage, ItemStack item, TileEntityReactorPlanner tile) {
        super(box);
        this.planner = tile;
        this.page = yourPage;
        this.stack = item;
    }

    public abstract LocaleComp getName();

    public boolean isPageSelected() {
        return this.planner.selectedView == this.page;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        Box2D box = this.getPosition();
        this.drawSideTab(gui, box.getX(), box.getY(), this.stack, this.planner.selectedView == this.page);
    }

    @SideOnly(value=Side.CLIENT)
    private void drawSideTab(GuiIC2 gui, int xOffset, int yOffset, ItemStack item, boolean enabled) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        RenderItem render = gui.getRenderItem();
        GL11.glPushMatrix();
        gui.func_73729_b(x + xOffset, y + yOffset, enabled ? 122 : 156, 212, enabled ? 31 : 28, 28);
        RenderHelper.func_74520_c();
        gui.setZLevel(200);
        render.field_77023_b = 200.0f;
        render.func_180450_b(item, x + xOffset + 8, y + yOffset + 6);
        gui.setZLevel(0);
        render.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        GlStateManager.func_179144_i((int)gui.getTextureObject().func_110552_b());
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return super.isMouseOver(mouseX, mouseY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseClick(GuiIC2 gui, int mouseX, int mouseY, int mouseButton) {
        if (this.isPageSelected()) {
            return false;
        }
        IC2.audioManager.playOnce(this.planner, SoundEvents.field_187909_gi.func_187503_a());
        ByteShifter shifter = new ByteShifter();
        shifter.writeInteger(0, 1);
        shifter.writeInteger(3, 3);
        this.planner.getNetwork().initiateClientTileEntityEvent(this.planner, shifter.getEncodedData(), this.page);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY)) {
            tooltips.add(this.getName().getLocalized());
        }
    }
}

