/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.RandomUtils;

public class CollectionHelper {
    public static <T, U> boolean equalsWithoutOrder(List<T> fst, List<U> snd, BiPredicate<T, U> equality) {
        if (fst != null && snd != null) {
            if (fst.size() == snd.size()) {
                ArrayList<T> cfst = new ArrayList<T>(fst);
                ArrayList<U> csnd = new ArrayList<U>(snd);
                Iterator ifst = cfst.iterator();
                while (ifst.hasNext()) {
                    Object a = ifst.next();
                    Iterator isnd = csnd.iterator();
                    boolean foundEqualObject = false;
                    while (isnd.hasNext()) {
                        Object b = isnd.next();
                        if (!equality.test(a, b)) continue;
                        ifst.remove();
                        isnd.remove();
                        foundEqualObject = true;
                        break;
                    }
                    if (foundEqualObject) continue;
                    break;
                }
                if (cfst.isEmpty()) {
                    return true;
                }
            }
        } else if (fst == null && snd == null) {
            return true;
        }
        return false;
    }

    @Nonnull
    public static <T> Optional<T> randomElement(Collection<T> collection, ToIntFunction<T> weightFunction) {
        int totalWeight = collection.stream().mapToInt(weightFunction).sum();
        int randomWeight = RandomUtils.nextInt((int)1, (int)(totalWeight + 1));
        for (T t : collection) {
            if ((randomWeight -= weightFunction.applyAsInt(t)) > 0) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static <T> List<List<T>> transpose(List<List<T>> list) {
        if (list.isEmpty()) {
            return list;
        }
        int width = list.get(0).size();
        int height = list.size();
        Preconditions.checkArgument((boolean)list.stream().allMatch(l -> l.size() == width), (Object)"Not all lists have the same size");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)width);
        for (int i = 0; i < width; ++i) {
            result.add(Lists.newArrayListWithExpectedSize((int)height));
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                ((List)result.get(x)).add(list.get(y).get(x));
            }
        }
        return result;
    }

    public static <T> List<List<T>> makeSameSize(List<List<T>> list, T filler) {
        int maxSize = list.stream().mapToInt(Collection::size).max().orElse(0);
        for (List<T> ts : list) {
            while (ts.size() < maxSize) {
                ts.add(filler);
            }
        }
        return list;
    }
}

