/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerUtils {
    public static boolean canFluidsStack(@Nullable FluidStack a, @Nullable FluidStack b) {
        if (a == null || a.amount <= 0) {
            return b == null || b.amount <= 0;
        }
        if (b == null || b.amount <= 0) {
            return false;
        }
        return a.getFluid().getName().equals(b.getFluid().getName()) && Objects.equals(a.tag, b.tag);
    }

    @Nullable
    public static FluidStack copyStackWithAmount(@Nullable FluidStack base, int amount) {
        if (base == null || amount <= 0) {
            return null;
        }
        FluidStack newStack = base.copy();
        newStack.amount = amount;
        return newStack;
    }

    public static IFluidHandler restrict(IFluidHandler fluidHandler, boolean allowInsert, boolean allowExtract) {
        return new RestrictedFluidHandler(fluidHandler, allowInsert, allowExtract);
    }

    @Deprecated
    public static IFluidHandler insertOnly(IFluidHandler fluidHandler) {
        return FluidHandlerUtils.restrict(fluidHandler, true, false);
    }

    @Deprecated
    public static IFluidHandler extractOnly(IFluidHandler fluidHandler) {
        return FluidHandlerUtils.restrict(fluidHandler, false, true);
    }

    public static IFluidTank restrict(IFluidTank tank, boolean allowInsert, boolean allowExtract) {
        return new RestrictedFluidTank(tank, allowInsert, allowExtract);
    }

    @Deprecated
    public static IFluidTank insertOnly(IFluidTank tank) {
        return FluidHandlerUtils.restrict(tank, true, false);
    }

    @Deprecated
    public static IFluidTank extractOnly(IFluidTank tank) {
        return FluidHandlerUtils.restrict(tank, false, true);
    }

    public static IFluidHandler asFluidHandler(IFluidTank tank, boolean canFill, boolean canDrain) {
        return new TankFluidHandler(tank, canFill, canDrain);
    }

    public static IFluidHandler asFluidHandler(IFluidTank tank) {
        return new TankFluidHandler(tank, true, true);
    }

    private static class TankFluidHandler
    implements IFluidHandler {
        private final IFluidTank tank;
        private final boolean canFill;
        private final boolean canDrain;

        public TankFluidHandler(IFluidTank tank, boolean canFill, boolean canDrain) {
            this.tank = tank;
            this.canFill = canFill;
            this.canDrain = canDrain;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(this.tank.getFluid(), this.tank.getCapacity(), this.canFill, this.canDrain)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return this.canFill ? this.tank.fill(resource, doFill) : 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!this.canDrain || resource.amount <= 0 || !FluidHandlerUtils.canFluidsStack(resource, this.tank.getFluid())) {
                return null;
            }
            return this.tank.drain(resource.amount, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return this.canDrain ? this.tank.drain(maxDrain, doDrain) : null;
        }
    }

    private static class RestrictedFluidTank
    implements IFluidTank {
        private final IFluidTank delegate;
        private final boolean allowInsert;
        private final boolean allowExtract;

        private RestrictedFluidTank(IFluidTank delegate, boolean allowInsert, boolean allowExtract) {
            this.delegate = delegate;
            this.allowInsert = allowInsert;
            this.allowExtract = allowExtract;
        }

        @Nullable
        public FluidStack getFluid() {
            return this.delegate.getFluid();
        }

        public int getFluidAmount() {
            return this.delegate.getFluidAmount();
        }

        public int getCapacity() {
            return this.delegate.getCapacity();
        }

        public FluidTankInfo getInfo() {
            return this.delegate.getInfo();
        }

        public int fill(FluidStack fluid, boolean simulate) {
            return this.allowInsert ? this.delegate.fill(fluid, simulate) : 0;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean simulate) {
            return this.allowExtract ? this.delegate.drain(maxDrain, simulate) : null;
        }
    }

    private static class RestrictedFluidHandler
    implements IFluidHandler {
        private final IFluidHandler delegate;
        private final boolean allowInsert;
        private final boolean allowExtract;

        private RestrictedFluidHandler(IFluidHandler delegate, boolean allowInsert, boolean allowExtract) {
            this.delegate = delegate;
            this.allowInsert = allowInsert;
            this.allowExtract = allowExtract;
        }

        public IFluidTankProperties[] getTankProperties() {
            return (IFluidTankProperties[])Arrays.stream(this.delegate.getTankProperties()).map(x$0 -> new TankPropertiesWrapper((IFluidTankProperties)x$0)).toArray(IFluidTankProperties[]::new);
        }

        public int fill(FluidStack fluid, boolean simulate) {
            return this.allowInsert ? this.delegate.fill(fluid, simulate) : 0;
        }

        @Nullable
        public FluidStack drain(FluidStack fluid, boolean simulate) {
            return this.allowExtract ? this.delegate.drain(fluid, simulate) : null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean simulate) {
            return this.allowExtract ? this.delegate.drain(maxDrain, simulate) : null;
        }

        private class TankPropertiesWrapper
        implements IFluidTankProperties {
            private final IFluidTankProperties delegateProps;

            private TankPropertiesWrapper(IFluidTankProperties delegateProps) {
                this.delegateProps = delegateProps;
            }

            @Nullable
            public FluidStack getContents() {
                return this.delegateProps.getContents();
            }

            public int getCapacity() {
                return this.delegateProps.getCapacity();
            }

            public boolean canFill() {
                return RestrictedFluidHandler.this.allowInsert && this.delegateProps.canFill();
            }

            public boolean canDrain() {
                return RestrictedFluidHandler.this.allowExtract && this.delegateProps.canDrain();
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return RestrictedFluidHandler.this.allowInsert && this.delegateProps.canFillFluidType(fluidStack);
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return RestrictedFluidHandler.this.allowExtract && this.delegateProps.canDrainFluidType(fluidStack);
            }
        }
    }
}

