/*
 * Decompiled with CFR 0.152.
 */
package locusway.overpoweredarmorbar.overlay;

import locusway.overpoweredarmorbar.ModConfig;
import locusway.overpoweredarmorbar.overlay.ArmorBar;
import locusway.overpoweredarmorbar.overlay.ArmorIcon;
import locusway.overpoweredarmorbar.overlay.ArmorIconColor;
import locusway.overpoweredarmorbar.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OverlayEventHandler {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private Minecraft mc = Minecraft.func_71410_x();
    private ArmorIcon[] armorIcons;

    public static void drawTexturedModalRect(float x, float y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.func_175174_a(x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderGameOverlayEventPre(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        int scaledWidth = event.getResolution().func_78326_a();
        int scaledHeight = event.getResolution().func_78328_b();
        event.setCanceled(true);
        ClientProxy.handler.renderArmorBar(scaledWidth, scaledHeight);
        if (ClientProxy.lava) {
            ClientProxy.lavahandler.renderLavaCharm(event);
        }
    }

    private int calculateArmorValue() {
        int currentArmorValue = this.mc.field_71439_g.func_70658_aO();
        for (ItemStack itemStack : this.mc.field_71439_g.func_184193_aE()) {
            if (!(itemStack.func_77973_b() instanceof ISpecialArmor)) continue;
            ISpecialArmor specialArmor = (ISpecialArmor)itemStack.func_77973_b();
            currentArmorValue += specialArmor.getArmorDisplay((EntityPlayer)this.mc.field_71439_g, itemStack, 0);
        }
        return currentArmorValue;
    }

    public void renderArmorBar(int screenWidth, int screenHeight) {
        EntityPlayerSP player = this.mc.field_71439_g;
        int currentArmorValue = this.calculateArmorValue();
        int xStart = screenWidth / 2 - 91;
        int yStart = screenHeight - 39;
        IAttributeInstance playerHealthAttribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float playerHealth = (float)playerHealthAttribute.func_111126_e();
        if (!ModConfig.offset && playerHealth > 20.0f) {
            playerHealth = 20.0f;
        }
        float absorptionAmount = MathHelper.func_76123_f((float)player.func_110139_bj());
        if (!ModConfig.offset && absorptionAmount > 20.0f) {
            absorptionAmount = 20.0f;
        }
        int numberOfHealthBars = (int)Math.ceil(playerHealth / 20.0f) + (int)Math.ceil(absorptionAmount / 20.0f);
        int i2 = Math.max(10 - (numberOfHealthBars - 2), 3);
        int yPosition = yStart - (numberOfHealthBars - 1) * i2 - 10;
        if (currentArmorValue != this.previousArmorValue) {
            this.armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
            this.previousArmorValue = currentArmorValue;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int armorIconCounter = 0;
        for (ArmorIcon icon : this.armorIcons) {
            int xPosition = xStart + armorIconCounter * 8;
            switch (icon.armorIconType) {
                case NONE: {
                    ArmorIconColor color = icon.primaryArmorIconColor;
                    GlStateManager.func_179131_c((float)color.Red, (float)color.Green, (float)color.Blue, (float)color.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                        break;
                    }
                    if (!ModConfig.showEmptyArmorIcons || !ModConfig.alwaysShowArmorBar && currentArmorValue <= 0) break;
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 16, 9, 9, 9);
                    break;
                }
                case HALF: {
                    ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                    ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                    GlStateManager.func_179131_c((float)firstHalfColor.Red, (float)firstHalfColor.Green, (float)firstHalfColor.Blue, (float)firstHalfColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 25, 9, 5, 9);
                    GlStateManager.func_179131_c((float)secondHalfColor.Red, (float)secondHalfColor.Green, (float)secondHalfColor.Blue, (float)secondHalfColor.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 39, 9, 4, 9);
                        break;
                    }
                    OverlayEventHandler.drawTexturedModalRect(xPosition + 5, yPosition, 30, 9, 4, 9);
                    break;
                }
                case FULL: {
                    ArmorIconColor fullColor = icon.primaryArmorIconColor;
                    GlStateManager.func_179131_c((float)fullColor.Red, (float)fullColor.Green, (float)fullColor.Blue, (float)fullColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(xPosition, yPosition, 34, 9, 9, 9);
                    break;
                }
            }
            ++armorIconCounter;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void forceUpdate() {
        ClientProxy.handler.previousArmorValue = -1;
    }
}

