/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.baked.BakedVariable;
import alexiil.mc.mod.load.json.JsonConfigurable;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.FunctionContext;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.InternalCompiler;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.IExpressionNode;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.NodeTypes;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.node.value.NodeVariable;

public class JsonVariable
extends JsonConfigurable<JsonVariable, BakedVariable> {
    public final String name;
    public final String value;
    public final boolean constant;

    public JsonVariable(boolean constant, String name, String value) {
        boolean specified = false;
        boolean specifiedAsConstant = false;
        if (name.startsWith("variable ")) {
            specified = true;
            specifiedAsConstant = false;
        } else if (name.startsWith("constant ") || name.startsWith("const ")) {
            specified = true;
            specifiedAsConstant = true;
        }
        if (specified) {
            this.constant = specifiedAsConstant;
            this.name = name.substring(name.indexOf(" ") + 1);
        } else {
            this.constant = constant;
            this.name = name;
        }
        this.value = value;
    }

    @Override
    protected BakedVariable actuallyBake(FunctionContext context) throws InvalidExpressionException {
        IExpressionNode node = InternalCompiler.compileExpression(this.value, context);
        NodeVariable variable = NodeTypes.makeVariableNode(NodeTypes.getType(node), this.name);
        if (this.constant) {
            node = NodeTypes.createConstantNode(node);
        }
        BakedVariable bv = new BakedVariable(this.constant, variable, node);
        if (this.constant) {
            context.putVariable(this.name, node);
            return bv;
        }
        context.putVariable(this.name, variable);
        return bv;
    }

    public static final class JsonConstant
    extends JsonVariable {
        public JsonConstant(boolean constant, String name, String value) {
            super(constant, name, value);
        }
    }
}

