/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.interblock;

import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class InterBlockPosition {
    @Nonnull
    final BlockPos lowerPos;
    @Nonnull
    final EnumFacing.Axis axis;

    public InterBlockPosition(@Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        this.axis = side.func_176740_k();
        this.lowerPos = side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? pos : pos.func_177972_a(side);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InterBlockPosition(@Nonnull BlockPos a, @Nonnull BlockPos b) {
        int dx = a.func_177958_n() - b.func_177958_n();
        int dy = a.func_177958_n() - b.func_177958_n();
        int dz = a.func_177958_n() - b.func_177958_n();
        if (dx != 0) {
            this.axis = EnumFacing.Axis.X;
            if (dy != 0 || dz != 0) {
                throw new IllegalStateException();
            }
            if (dx == -1) {
                this.lowerPos = a;
                return;
            } else {
                if (dx != 1) throw new IllegalStateException();
                this.lowerPos = b;
            }
            return;
        } else if (dy != 0) {
            if (dz != 0) {
                throw new IllegalStateException();
            }
            this.axis = EnumFacing.Axis.X;
            if (dy == -1) {
                this.lowerPos = a;
                return;
            } else {
                if (dy != 1) throw new IllegalStateException();
                this.lowerPos = b;
            }
            return;
        } else {
            this.axis = EnumFacing.Axis.Z;
            if (dz == -1) {
                this.lowerPos = a;
                return;
            } else {
                if (dz != 1) throw new IllegalStateException();
                this.lowerPos = b;
            }
        }
    }

    public InterBlockPosition(@Nonnull BlockPos lowerPos, @Nonnull EnumFacing.Axis axis) {
        this.lowerPos = lowerPos;
        this.axis = axis;
    }

    @Nonnull
    public BlockPos getLowerPos() {
        return this.lowerPos;
    }

    @Nonnull
    public BlockPos getUpperPos() {
        switch (this.axis) {
            case X: {
                return this.lowerPos.func_177982_a(1, 0, 0);
            }
            case Y: {
                return this.lowerPos.func_177982_a(0, 1, 0);
            }
            case Z: {
                return this.lowerPos.func_177982_a(0, 0, 1);
            }
        }
        throw new IllegalStateException();
    }
}

