/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.commands;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.config.TECurrency;
import com.erigitic.main.TotalEconomy;
import com.erigitic.util.MessageManager;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ViewBalanceCommand
implements CommandExecutor {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private MessageManager messageManager;

    public ViewBalanceCommand(TotalEconomy totalEconomy, AccountManager accountManager, MessageManager messageManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
        this.messageManager = messageManager;
    }

    public CommandResult execute(CommandSource sender, CommandContext args) throws CommandException {
        User recipient = (User)args.getOne("player").get();
        Optional optCurrencyName = args.getOne("currencyName");
        TEAccount recipientAccount = (TEAccount)this.accountManager.getOrCreateAccount(recipient.getUniqueId()).get();
        TransactionResult transactionResult = this.getTransactionResult(recipientAccount, optCurrencyName);
        if (transactionResult.getResult() == ResultType.SUCCESS) {
            TECurrency currency = (TECurrency)transactionResult.getCurrency();
            Text balanceText = currency.format(recipientAccount.getBalance(currency));
            HashMap<String, String> messageValues = new HashMap<String, String>();
            messageValues.put("recipient", recipient.getName());
            messageValues.put("amount", balanceText.toPlain());
            sender.sendMessage(this.messageManager.getMessage("command.viewbalance", messageValues));
            return CommandResult.success();
        }
        throw new CommandException((Text)Text.of((String)"[TE] An error occurred setting a player's balance!"));
    }

    private TransactionResult getTransactionResult(TEAccount recipientAccount, Optional<String> optCurrencyName) throws CommandException {
        Cause cause = Cause.builder().append((Object)this.totalEconomy.getPluginContainer()).build(EventContext.empty());
        if (optCurrencyName.isPresent()) {
            Optional<Currency> optCurrency = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + optCurrencyName.get().toLowerCase());
            if (optCurrency.isPresent()) {
                TECurrency currency = (TECurrency)optCurrency.get();
                BigDecimal balance = recipientAccount.getBalance(currency);
                return recipientAccount.setBalance(currency, balance, cause);
            }
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "[TE] The specified currency does not exist!"}));
        }
        BigDecimal balance = recipientAccount.getBalance(this.totalEconomy.getDefaultCurrency());
        return recipientAccount.setBalance(this.totalEconomy.getDefaultCurrency(), balance, cause);
    }
}

