/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.gui;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.capabilities.inventory.SidedItemHandlerConfig;
import net.ndrei.teslacorelib.gui.BasicContainerGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.gui.SideConfigurator$WhenMappings;
import net.ndrei.teslacorelib.inventory.ColoredItemHandlerInfo;
import net.ndrei.teslacorelib.localization.LocalizationKt;
import net.ndrei.teslacorelib.netsync.SimpleNBTMessage;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ<\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J4\u0010\u0019\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J4\u0010\u001a\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016JJ\u0010\u001b\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J&\u0010\"\u001a\u0004\u0018\u00010\u001e2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J,\u0010#\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0016J\u000e\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0003R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/ndrei/teslacorelib/gui/SideConfigurator;", "Lnet/ndrei/teslacorelib/gui/BasicContainerGuiPiece;", "left", "", "top", "width", "height", "sidedConfig", "Lnet/ndrei/teslacorelib/capabilities/inventory/SidedItemHandlerConfig;", "entity", "Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;", "(IIIILnet/ndrei/teslacorelib/capabilities/inventory/SidedItemHandlerConfig;Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;)V", "lockPiece", "Lnet/ndrei/teslacorelib/gui/LockedInventoryTogglePiece;", "selectedInventory", "drawBackgroundLayer", "", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "guiX", "guiY", "partialTicks", "", "mouseX", "mouseY", "drawForegroundLayer", "drawForegroundTopLayer", "drawSide", "sides", "", "Lnet/minecraft/util/EnumFacing;", "side", "column", "row", "getSide", "mouseClicked", "mouseButton", "setSelectedInventory", "index", "tesla-core-lib"})
public final class SideConfigurator
extends BasicContainerGuiPiece {
    private int selectedInventory;
    private LockedInventoryTogglePiece lockPiece;
    private final SidedItemHandlerConfig sidedConfig;
    private final SidedTileEntity entity;

    public final void setSelectedInventory(int index) {
        EnumDyeColor color;
        this.selectedInventory = index;
        this.lockPiece = null;
        this.setVisibility(this.selectedInventory >= 0);
        List<ColoredItemHandlerInfo> colors = this.sidedConfig.getColoredInfo();
        int n = this.selectedInventory;
        if (0 <= n && colors.size() > n && this.entity.getInventoryLockState(color = colors.get(this.selectedInventory).getColor()) != null) {
            this.lockPiece = new LockedInventoryTogglePiece(this.getLeft() + 108 + 2, this.getTop() + 18 + 2, this.entity, color);
        }
    }

    @Override
    public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
        block1: {
            Intrinsics.checkParameterIsNotNull(container, (String)"container");
            List<ColoredItemHandlerInfo> colors = this.sidedConfig.getColoredInfo();
            if (this.selectedInventory < 0 || this.selectedInventory >= colors.size()) {
                return;
            }
            EnumDyeColor color = colors.get(this.selectedInventory).getColor();
            List<EnumFacing> sides = this.sidedConfig.getSidesForColor(color);
            container.bindDefaultTexture();
            this.drawSide(container, sides, EnumFacing.UP, 2, 0, mouseX, mouseY);
            this.drawSide(container, sides, EnumFacing.WEST, 1, 1, mouseX, mouseY);
            this.drawSide(container, sides, EnumFacing.SOUTH, 2, 1, mouseX, mouseY);
            this.drawSide(container, sides, EnumFacing.EAST, 3, 1, mouseX, mouseY);
            this.drawSide(container, sides, EnumFacing.DOWN, 2, 2, mouseX, mouseY);
            this.drawSide(container, sides, EnumFacing.NORTH, 3, 2, mouseX, mouseY);
            LockedInventoryTogglePiece lockedInventoryTogglePiece = this.lockPiece;
            if (lockedInventoryTogglePiece == null) break block1;
            lockedInventoryTogglePiece.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
        }
    }

    @Override
    public void drawForegroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
        block0: {
            Intrinsics.checkParameterIsNotNull(container, (String)"container");
            super.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
            LockedInventoryTogglePiece lockedInventoryTogglePiece = this.lockPiece;
            if (lockedInventoryTogglePiece == null) break block0;
            lockedInventoryTogglePiece.drawForegroundLayer(container, guiX, guiY, mouseX, mouseY);
        }
    }

    @Override
    public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
        block7: {
            Intrinsics.checkParameterIsNotNull(container, (String)"container");
            super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
            EnumFacing facing = this.getSide(container, mouseX, mouseY);
            if (facing != null) {
                String string;
                switch (SideConfigurator$WhenMappings.$EnumSwitchMapping$0[facing.ordinal()]) {
                    case 1: {
                        string = LocalizationKt.localizeModString$default("teslacorelib", "side config", "back", null, 8, null).func_150254_d();
                        break;
                    }
                    case 2: {
                        string = LocalizationKt.localizeModString$default("teslacorelib", "side config", "front", null, 8, null).func_150254_d();
                        break;
                    }
                    case 3: {
                        string = LocalizationKt.localizeModString$default("teslacorelib", "side config", "right", null, 8, null).func_150254_d();
                        break;
                    }
                    case 4: {
                        string = LocalizationKt.localizeModString$default("teslacorelib", "side config", "left", null, 8, null).func_150254_d();
                        break;
                    }
                    default: {
                        String string2 = facing.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"facing.toString()");
                        string = LocalizationKt.localizeModString$default("teslacorelib", "side config", string2, null, 8, null).func_150254_d();
                    }
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when (facing) {\n        \u2026rmattedText\n            }");
                container.drawTooltip(CollectionsKt.listOf((Object)StringsKt.capitalize((String)string)), mouseX - guiX - (mouseX - guiX - this.getLeft()) % 18 + 9, mouseY - guiY - (mouseY - guiY - this.getTop()) % 18 + 9);
            }
            LockedInventoryTogglePiece lockedInventoryTogglePiece = this.lockPiece;
            if (lockedInventoryTogglePiece == null) break block7;
            lockedInventoryTogglePiece.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
        }
    }

    @Override
    public void mouseClicked(@NotNull BasicTeslaGuiContainer<?> container, int mouseX, int mouseY, int mouseButton) {
        block4: {
            EnumFacing facing;
            Intrinsics.checkParameterIsNotNull(container, (String)"container");
            if (this.selectedInventory >= 0 && this.isInside(container, mouseX, mouseY) && (facing = this.getSide(container, mouseX, mouseY)) != null) {
                EnumDyeColor color = this.sidedConfig.getColoredInfo().get(this.selectedInventory).getColor();
                this.sidedConfig.toggleSide(color, facing);
                NBTTagCompound nbt = this.entity.setupSpecialNBTMessage("TOGGLE_SIDE");
                nbt.func_74768_a("color", color.func_176765_a());
                nbt.func_74768_a("side", facing.func_176745_a());
                TeslaCoreLib.INSTANCE.getNetwork().sendToServer(new SimpleNBTMessage(this.entity, nbt));
            }
            if (this.lockPiece == null) break block4;
            LockedInventoryTogglePiece lockedInventoryTogglePiece = this.lockPiece;
            if (lockedInventoryTogglePiece == null) {
                Intrinsics.throwNpe();
            }
            if (BasicContainerGuiPiece.Companion.isInside(container, lockedInventoryTogglePiece, mouseX, mouseY)) {
                LockedInventoryTogglePiece lockedInventoryTogglePiece2 = this.lockPiece;
                if (lockedInventoryTogglePiece2 != null) {
                    lockedInventoryTogglePiece2.mouseClicked(container, mouseX, mouseY, mouseButton);
                }
            }
        }
    }

    private final EnumFacing getSide(BasicTeslaGuiContainer<?> container, int mouseX, int mouseY) {
        int localX;
        int column;
        int n;
        int localY = mouseY - container.getGuiTop() - this.getTop();
        int row = localY / 18;
        EnumFacing facing = null;
        int n2 = row;
        if (0 <= n2 && 2 >= n2 && 1 <= (n = (column = (localX = mouseX - container.getGuiLeft() - this.getLeft()) / 18)) && 3 >= n && 2 <= (n = (localX -= column * 18)) && 15 >= n && 2 <= (n = (localY -= row * 18)) && 15 >= n) {
            block0 : switch (row) {
                case 0: {
                    switch (column) {
                        case 2: {
                            facing = EnumFacing.UP;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (column) {
                        case 1: {
                            facing = EnumFacing.WEST;
                            break;
                        }
                        case 2: {
                            facing = EnumFacing.SOUTH;
                            break;
                        }
                        case 3: {
                            facing = EnumFacing.EAST;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (column) {
                        case 2: {
                            facing = EnumFacing.DOWN;
                            break block0;
                        }
                        case 3: {
                            facing = EnumFacing.NORTH;
                        }
                    }
                }
            }
        }
        return facing;
    }

    private final void drawSide(BasicTeslaGuiContainer<?> container, List<? extends EnumFacing> sides, EnumFacing side, int column, int row, int mouseX, int mouseY) {
        int x = this.getLeft() + column * 18 + 2;
        int y = this.getTop() + row * 18 + 2;
        container.drawTexturedRect(x, y, 110, 210, 14, 14);
        int n = mouseX - container.getGuiLeft();
        if (x <= n && x + 14 >= n && y <= (n = mouseY - container.getGuiTop()) && y + 14 >= n) {
            container.drawFilledRect(container.getGuiLeft() + x + 1, container.getGuiTop() + y + 1, 12, 12, 0x42FFFFFF);
        }
        container.drawTexturedRect(x, y, sides.contains(side) ? 182 : 146, 210, 14, 14);
    }

    public SideConfigurator(int left, int top, int width, int height, @NotNull SidedItemHandlerConfig sidedConfig, @NotNull SidedTileEntity entity) {
        Intrinsics.checkParameterIsNotNull((Object)sidedConfig, (String)"sidedConfig");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        super(left, top, width, height);
        this.sidedConfig = sidedConfig;
        this.entity = entity;
        this.selectedInventory = -1;
        this.setSelectedInventory(-1);
    }
}

