/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import java.util.HashSet;
import java.util.Set;
import org.spongepowered.api.GameState;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;

public class SpongeConfigSaveManager {
    private final Set<SpongeConfig<?>> stagedConfigs = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(SpongeConfig<?> spongeConfig) {
        SpongeConfigSaveManager spongeConfigSaveManager = this;
        synchronized (spongeConfigSaveManager) {
            if (!SpongeImpl.isInitialized() || SpongeImpl.getGame().getState() == GameState.SERVER_STARTED || SpongeImpl.getGame().getState() == GameState.GAME_STOPPED) {
                if (!this.stagedConfigs.isEmpty()) {
                    this.stagedConfigs.add(spongeConfig);
                    this.flush();
                } else {
                    spongeConfig.saveNow();
                }
            } else {
                this.stagedConfigs.add(spongeConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush(SpongeConfig<?> config) {
        SpongeConfigSaveManager spongeConfigSaveManager = this;
        synchronized (spongeConfigSaveManager) {
            if (this.stagedConfigs.remove(config)) {
                return config.saveNow();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (!this.stagedConfigs.isEmpty()) {
            SpongeConfigSaveManager spongeConfigSaveManager = this;
            synchronized (spongeConfigSaveManager) {
                for (SpongeConfig<?> spongeConfig : this.stagedConfigs) {
                    spongeConfig.saveNow();
                }
                this.stagedConfigs.clear();
            }
        }
    }
}

