/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableVehicleData;
import org.spongepowered.api.data.manipulator.mutable.entity.VehicleData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeVehicleData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeVehicleData
extends AbstractImmutableData<ImmutableVehicleData, VehicleData>
implements ImmutableVehicleData {
    private final EntitySnapshot vehicle;
    private final EntitySnapshot baseVehicle;
    private final ImmutableValue<EntitySnapshot> vehicleValue;
    private final ImmutableValue<EntitySnapshot> baseVehicleValue;

    public ImmutableSpongeVehicleData(EntitySnapshot vehicle, EntitySnapshot baseVehicle) {
        super(ImmutableVehicleData.class);
        this.vehicle = (EntitySnapshot)Preconditions.checkNotNull((Object)vehicle, (Object)"vehicle");
        this.baseVehicle = (EntitySnapshot)Preconditions.checkNotNull((Object)baseVehicle, (Object)"baseVehicle");
        this.vehicleValue = new ImmutableSpongeValue<EntitySnapshot>(Keys.VEHICLE, this.vehicle);
        this.baseVehicleValue = new ImmutableSpongeValue<EntitySnapshot>(Keys.BASE_VEHICLE, this.baseVehicle);
        this.registerGetters();
    }

    public ImmutableSpongeVehicleData(Entity vehicle, Entity baseVehicle) {
        this(vehicle.createSnapshot(), baseVehicle.createSnapshot());
    }

    @Override
    public ImmutableValue<EntitySnapshot> vehicle() {
        return this.vehicleValue;
    }

    @Override
    public ImmutableValue<EntitySnapshot> baseVehicle() {
        return this.baseVehicleValue;
    }

    @Override
    public VehicleData asMutable() {
        return new SpongeVehicleData(this.vehicle, this.baseVehicle);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.VEHICLE, (Object)this.vehicle).set(Keys.BASE_VEHICLE, (Object)this.baseVehicle);
    }

    public EntitySnapshot getVehicle() {
        return this.vehicle;
    }

    public EntitySnapshot getBaseVehicle() {
        return this.baseVehicle;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.VEHICLE, this::getVehicle);
        this.registerKeyValue(Keys.VEHICLE, this::vehicle);
        this.registerFieldGetter(Keys.BASE_VEHICLE, this::getBaseVehicle);
        this.registerKeyValue(Keys.BASE_VEHICLE, this::baseVehicle);
    }
}

