/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAreaEffectCloudData;
import org.spongepowered.api.data.manipulator.mutable.entity.AreaEffectCloudData;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.effect.particle.ParticleType;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeAreaEffectCloudData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.util.ImplementationRequiredForTest;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

@ImplementationRequiredForTest
public class SpongeAreaEffectData
extends AbstractData<AreaEffectCloudData, ImmutableAreaEffectCloudData>
implements AreaEffectCloudData {
    private Color color;
    private double radius;
    private ParticleType particleType;
    private int duration;
    private int waitTime;
    private double radiusOnUse;
    private double radiusPerTick;
    private int durationOnUse;
    private int reapplicationDelay;
    private List<PotionEffect> potionEffects;
    private int age;

    public SpongeAreaEffectData(Color color, double radius, ParticleType particleType, int duration, int waitTime, double radiusOnUse, double radiusPerTick, int durationOnUse, int reapplicationDelay, List<PotionEffect> potionEffects, int age) {
        super(AreaEffectCloudData.class);
        this.color = color;
        this.radius = radius;
        this.particleType = particleType;
        this.duration = duration;
        this.waitTime = waitTime;
        this.radiusOnUse = radiusOnUse;
        this.radiusPerTick = radiusPerTick;
        this.durationOnUse = durationOnUse;
        this.reapplicationDelay = reapplicationDelay;
        this.potionEffects = new ArrayList<PotionEffect>(potionEffects.size());
        this.potionEffects.addAll(potionEffects);
        this.age = age;
        this.registerGettersAndSetters();
    }

    public SpongeAreaEffectData() {
        super(AreaEffectCloudData.class);
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_AGE, () -> this.age);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_AGE, age -> {
            this.age = age < 0 ? 0 : age;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_AGE, this::age);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY, () -> this.reapplicationDelay);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY, age -> {
            this.reapplicationDelay = age < 0 ? 0 : age;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY, this::applicationDelay);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_COLOR, () -> this.color);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_COLOR, color -> {
            this.color = color;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_COLOR, this::color);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_DURATION, () -> this.duration);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_DURATION, duration -> {
            this.duration = duration < 0 ? 0 : duration;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_DURATION, this::duration);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE, () -> this.durationOnUse);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE, durationOnUse -> {
            this.durationOnUse = durationOnUse < 0 ? 0 : durationOnUse;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE, this::durationOnUse);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, () -> this.particleType);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, particleType -> {
            this.particleType = particleType;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, this::particleType);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_RADIUS, () -> this.radius);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_RADIUS, radius -> {
            this.radius = radius < 0.0 ? 0.0 : radius;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_RADIUS, this::radius);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE, () -> this.radiusOnUse);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE, radiusOnUse -> {
            this.radiusOnUse = radiusOnUse < 0.0 ? 0.0 : radiusOnUse;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE, this::radiusOnUse);
        this.registerFieldGetter(Keys.AREA_EFFECT_CLOUD_WAIT_TIME, () -> this.waitTime);
        this.registerFieldSetter(Keys.AREA_EFFECT_CLOUD_WAIT_TIME, waitTime -> {
            this.waitTime = waitTime < 0 ? 0 : waitTime;
        });
        this.registerKeyValue(Keys.AREA_EFFECT_CLOUD_WAIT_TIME, this::waitTime);
        this.registerFieldGetter(Keys.POTION_EFFECTS, () -> this.potionEffects);
        this.registerFieldSetter(Keys.POTION_EFFECTS, potionEffects1 -> {
            this.potionEffects = potionEffects1;
        });
        this.registerKeyValue(Keys.POTION_EFFECTS, this::effects);
    }

    @Override
    public AreaEffectCloudData copy() {
        return new SpongeAreaEffectData(this.color, this.radius, this.particleType, this.duration, this.waitTime, this.radiusOnUse, this.radiusPerTick, this.durationOnUse, this.reapplicationDelay, this.potionEffects, this.age);
    }

    @Override
    public ImmutableAreaEffectCloudData asImmutable() {
        return new ImmutableSpongeAreaEffectCloudData(this.color, this.radius, this.particleType, this.duration, this.waitTime, this.radiusOnUse, this.radiusPerTick, this.durationOnUse, this.reapplicationDelay, this.potionEffects, this.age);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.AREA_EFFECT_CLOUD_AGE, (Object)this.age).set(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY, (Object)this.reapplicationDelay).set(Keys.AREA_EFFECT_CLOUD_COLOR, (Object)this.color).set(Keys.AREA_EFFECT_CLOUD_DURATION, (Object)this.duration).set(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE, (Object)this.durationOnUse).set(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, (Object)this.particleType).set(Keys.AREA_EFFECT_CLOUD_RADIUS, (Object)this.radius).set(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE, (Object)this.radiusOnUse).set(Keys.AREA_EFFECT_CLOUD_WAIT_TIME, (Object)this.waitTime).set(Keys.POTION_EFFECTS, (Object)this.potionEffects);
    }

    @Override
    public Value<Color> color() {
        return new SpongeValue<Color>(Keys.AREA_EFFECT_CLOUD_COLOR, Color.WHITE, this.color);
    }

    @Override
    public MutableBoundedValue<Double> radius() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_RADIUS).minimum(0.0).maximum(3.4028234663852886E38).defaultValue(0.5).actualValue(this.radius).build();
    }

    @Override
    public Value<ParticleType> particleType() {
        return new SpongeValue<ParticleType>(Keys.AREA_EFFECT_CLOUD_PARTICLE_TYPE, ParticleTypes.MOB_SPELL, ParticleTypes.MOB_SPELL);
    }

    @Override
    public MutableBoundedValue<Integer> duration() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_DURATION).minimum(Integer.MIN_VALUE).maximum(Integer.MAX_VALUE).defaultValue(600).actualValue(this.duration).build();
    }

    @Override
    public MutableBoundedValue<Integer> waitTime() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_WAIT_TIME).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(20).actualValue(this.waitTime).build();
    }

    @Override
    public MutableBoundedValue<Double> radiusOnUse() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_RADIUS_ON_USE).minimum(0.0).maximum(3.4028234663852886E38).defaultValue(0.0).actualValue(this.radiusOnUse).build();
    }

    @Override
    public MutableBoundedValue<Double> radiusPerTick() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_RADIUS_PER_TICK).minimum(0.0).maximum(3.4028234663852886E38).defaultValue(0.0).actualValue(this.radiusPerTick).build();
    }

    @Override
    public MutableBoundedValue<Integer> durationOnUse() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_DURATION_ON_USE).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(this.durationOnUse).build();
    }

    @Override
    public MutableBoundedValue<Integer> applicationDelay() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_REAPPLICATION_DELAY).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue(this.reapplicationDelay).build();
    }

    @Override
    public ListValue<PotionEffect> effects() {
        return new SpongeListValue<PotionEffect>(Keys.POTION_EFFECTS, this.potionEffects);
    }

    @Override
    public MutableBoundedValue<Integer> age() {
        return SpongeValueFactory.boundedBuilder(Keys.AREA_EFFECT_CLOUD_AGE).defaultValue(0).minimum(0).maximum(Integer.MAX_VALUE).actualValue(this.age).build();
    }
}

