/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutablePickupDelayData;
import org.spongepowered.api.data.manipulator.mutable.entity.PickupDelayData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongePickupDelayData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public final class SpongePickupDelayData
extends AbstractData<PickupDelayData, ImmutablePickupDelayData>
implements PickupDelayData {
    private int value;

    public SpongePickupDelayData() {
        this(0);
    }

    public SpongePickupDelayData(int value, int minimum, int maximum, int defaultValue) {
        this(value);
    }

    public SpongePickupDelayData(int value) {
        super(PickupDelayData.class);
        this.value = value;
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.INFINITE_PICKUP_DELAY, this::isInifinitePickup);
        this.registerFieldSetter(Keys.INFINITE_PICKUP_DELAY, value -> {
            this.value = value != false ? Short.MAX_VALUE : this.value;
        });
        this.registerKeyValue(Keys.INFINITE_PICKUP_DELAY, this::infinite);
        this.registerFieldGetter(Keys.PICKUP_DELAY, this::getDelay);
        this.registerFieldSetter(Keys.PICKUP_DELAY, value -> {
            this.value = value;
        });
        this.registerKeyValue(Keys.PICKUP_DELAY, this::delay);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.PICKUP_DELAY, (Object)this.value).set(Keys.INFINITE_PICKUP_DELAY, (Object)this.isInifinitePickup());
    }

    @Override
    public Value<Boolean> infinite() {
        return new SpongeValue<Boolean>(Keys.INFINITE_PICKUP_DELAY, false, this.isInifinitePickup());
    }

    private boolean isInifinitePickup() {
        return this.value == Short.MAX_VALUE;
    }

    @Override
    public MutableBoundedValue<Integer> delay() {
        return SpongeValueFactory.boundedBuilder(Keys.PICKUP_DELAY).actualValue(this.value).minimum((Integer)Short.MIN_VALUE).maximum((Integer)Short.MAX_VALUE).defaultValue(0).build();
    }

    private int getDelay() {
        return this.value;
    }

    @Override
    public PickupDelayData copy() {
        return new SpongePickupDelayData(this.value);
    }

    @Override
    public ImmutablePickupDelayData asImmutable() {
        return new ImmutableSpongePickupDelayData(this.value);
    }
}

