/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.passive.EntityParrot;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableParrotData;
import org.spongepowered.api.data.manipulator.mutable.entity.ParrotData;
import org.spongepowered.api.data.type.ParrotVariant;
import org.spongepowered.api.data.type.ParrotVariants;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeParrotData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.SpongeParrotVariant;
import org.spongepowered.common.registry.type.entity.ParrotVariantRegistryModule;

public class ParrotDataProcessor
extends AbstractEntitySingleDataProcessor<EntityParrot, ParrotVariant, Value<ParrotVariant>, ParrotData, ImmutableParrotData> {
    public ParrotDataProcessor() {
        super(EntityParrot.class, Keys.PARROT_VARIANT);
    }

    @Override
    protected boolean set(EntityParrot dataHolder, ParrotVariant value) {
        dataHolder.func_191997_m(((SpongeParrotVariant)value).type);
        return true;
    }

    @Override
    protected Optional<ParrotVariant> getVal(EntityParrot dataHolder) {
        return Optional.of(ParrotVariantRegistryModule.PARROT_VARIANT_IDMAP.get(dataHolder.func_191998_ds()));
    }

    @Override
    protected ImmutableValue<ParrotVariant> constructImmutableValue(ParrotVariant value) {
        return ImmutableSpongeValue.cachedOf(this.key, ParrotVariants.RED, value);
    }

    @Override
    protected Value<ParrotVariant> constructValue(ParrotVariant actualValue) {
        return new SpongeValue<ParrotVariant>(this.key, ParrotVariants.RED, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected ParrotData createManipulator() {
        return new SpongeParrotData();
    }
}

