/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableRepresentedItemData;
import org.spongepowered.api.data.manipulator.mutable.RepresentedItemData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.data.manipulator.mutable.SpongeRepresentedItemData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class RepresentedItemDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, ItemStackSnapshot, Value<ItemStackSnapshot>, RepresentedItemData, ImmutableRepresentedItemData> {
    public RepresentedItemDataProcessor() {
        super(Entity.class, Keys.REPRESENTED_ITEM);
    }

    @Override
    protected boolean set(Entity container, ItemStackSnapshot value) {
        if (container instanceof EntityItemFrame) {
            ((EntityItemFrame)container).func_82334_a((net.minecraft.item.ItemStack)value.createStack());
            return true;
        }
        if (container instanceof EntityItem) {
            ((EntityItem)container).func_92058_a((net.minecraft.item.ItemStack)value.createStack());
            return true;
        }
        return false;
    }

    @Override
    protected Optional<ItemStackSnapshot> getVal(Entity container) {
        if (container instanceof EntityItemFrame) {
            net.minecraft.item.ItemStack itemStack = ((EntityItemFrame)container).func_82335_i();
            if (!itemStack.func_190926_b()) {
                return Optional.of(((ItemStack)itemStack).createSnapshot());
            }
        } else if (container instanceof EntityItem) {
            return Optional.of(((ItemStack)((EntityItem)container).func_92059_d()).createSnapshot());
        }
        return Optional.empty();
    }

    @Override
    protected Value<ItemStackSnapshot> constructValue(ItemStackSnapshot defaultValue) {
        return new SpongeValue<ItemStackSnapshot>(this.key, defaultValue);
    }

    @Override
    protected ImmutableValue<ItemStackSnapshot> constructImmutableValue(ItemStackSnapshot value) {
        return new ImmutableSpongeValue<ItemStackSnapshot>(this.key, value);
    }

    @Override
    protected boolean supports(Entity holder) {
        return holder instanceof EntityItem || holder instanceof EntityItemFrame;
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (container instanceof EntityItemFrame) {
            EntityItemFrame frame = (EntityItemFrame)container;
            if (!frame.func_82335_i().func_190926_b()) {
                ImmutableValue<ItemStackSnapshot> old = this.constructImmutableValue(this.getVal((Entity)frame).get());
                frame.func_82334_a(net.minecraft.item.ItemStack.field_190927_a);
                return DataTransactionResult.successRemove(old);
            }
            return DataTransactionResult.successNoData();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    protected RepresentedItemData createManipulator() {
        return new SpongeRepresentedItemData();
    }
}

