/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import java.util.Optional;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityFlowerPot;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableRepresentedItemData;
import org.spongepowered.api.data.manipulator.mutable.RepresentedItemData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.data.manipulator.mutable.SpongeRepresentedItemData;
import org.spongepowered.common.data.processor.common.AbstractTileEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.block.BlockFlowerPotAccessor;

public class FlowerPotDataProcessor
extends AbstractTileEntitySingleDataProcessor<TileEntityFlowerPot, ItemStackSnapshot, Value<ItemStackSnapshot>, RepresentedItemData, ImmutableRepresentedItemData> {
    public FlowerPotDataProcessor() {
        super(TileEntityFlowerPot.class, Keys.REPRESENTED_ITEM);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof TileEntityFlowerPot)) {
            return DataTransactionResult.failNoData();
        }
        TileEntityFlowerPot flowerPot = (TileEntityFlowerPot)container;
        Optional<ItemStackSnapshot> old = this.getVal(flowerPot);
        if (!old.isPresent()) {
            return DataTransactionResult.successNoData();
        }
        flowerPot.func_190614_a(net.minecraft.item.ItemStack.field_190927_a);
        flowerPot.func_70296_d();
        return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
    }

    @Override
    protected boolean set(TileEntityFlowerPot flowerPot, ItemStackSnapshot stackSnapshot) {
        if (stackSnapshot == ItemStackSnapshot.NONE) {
            flowerPot.func_190614_a(net.minecraft.item.ItemStack.field_190927_a);
        } else {
            net.minecraft.item.ItemStack stack = (net.minecraft.item.ItemStack)stackSnapshot.createStack();
            if (!((BlockFlowerPotAccessor)Blocks.field_150457_bL).accessor$canItemBePotted(stack)) {
                return false;
            }
            flowerPot.func_190614_a(stack);
        }
        flowerPot.func_70296_d();
        flowerPot.func_145831_w().func_184138_a(flowerPot.func_174877_v(), flowerPot.func_145831_w().func_180495_p(flowerPot.func_174877_v()), flowerPot.func_145831_w().func_180495_p(flowerPot.func_174877_v()), 3);
        return true;
    }

    @Override
    protected Optional<ItemStackSnapshot> getVal(TileEntityFlowerPot flowerPot) {
        if (flowerPot.func_145965_a() == null) {
            return Optional.empty();
        }
        net.minecraft.item.ItemStack stack = new net.minecraft.item.ItemStack(flowerPot.func_145965_a(), 1, flowerPot.func_145966_b());
        return Optional.of(((ItemStack)stack).createSnapshot());
    }

    @Override
    protected Value<ItemStackSnapshot> constructValue(ItemStackSnapshot value) {
        return new SpongeValue<ItemStackSnapshot>(Keys.REPRESENTED_ITEM, ItemStackSnapshot.NONE, value);
    }

    @Override
    protected ImmutableValue<ItemStackSnapshot> constructImmutableValue(ItemStackSnapshot value) {
        return new ImmutableSpongeValue<ItemStackSnapshot>(Keys.REPRESENTED_ITEM, ItemStackSnapshot.NONE, value);
    }

    @Override
    protected RepresentedItemData createManipulator() {
        return new SpongeRepresentedItemData();
    }
}

