/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.tileentity;

import java.util.Optional;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.world.LockCode;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableLockableData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.LockableData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeLockableData;
import org.spongepowered.common.data.processor.common.AbstractTileEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public final class TileEntityLockableDataProcessor
extends AbstractTileEntitySingleDataProcessor<TileEntityLockable, String, Value<String>, LockableData, ImmutableLockableData> {
    public TileEntityLockableDataProcessor() {
        super(TileEntityLockable.class, Keys.LOCK_TOKEN);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        if (!(container instanceof TileEntityLockable)) {
            return DataTransactionResult.failNoData();
        }
        TileEntityLockable tile = (TileEntityLockable)container;
        Optional<String> old = this.getVal(tile);
        if (!old.isPresent()) {
            return DataTransactionResult.successNoData();
        }
        tile.func_174892_a(LockCode.field_180162_a);
        return DataTransactionResult.successRemove(this.constructImmutableValue(old.get()));
    }

    @Override
    protected boolean set(TileEntityLockable tile, String value) {
        tile.func_174892_a(value.length() == 0 ? LockCode.field_180162_a : new LockCode(value));
        return true;
    }

    @Override
    protected Optional<String> getVal(TileEntityLockable tile) {
        if (tile.func_174893_q_()) {
            return Optional.of(tile.func_174891_i().func_180159_b());
        }
        return Optional.empty();
    }

    @Override
    protected Value<String> constructValue(String actualValue) {
        return new SpongeValue<String>(Keys.LOCK_TOKEN, "", actualValue);
    }

    @Override
    protected ImmutableValue<String> constructImmutableValue(String value) {
        return new ImmutableSpongeValue<String>(Keys.LOCK_TOKEN, "", value);
    }

    @Override
    protected LockableData createManipulator() {
        return new SpongeLockableData();
    }
}

