/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.mixin.core.entity.EntityAccessor;

public class FireDamageDelayValueProcessor
extends AbstractSpongeValueProcessor<Entity, Integer, MutableBoundedValue<Integer>> {
    public FireDamageDelayValueProcessor() {
        super(Entity.class, Keys.FIRE_DAMAGE_DELAY);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.FIRE_DAMAGE_DELAY).defaultValue(20).minimum(0).maximum(Integer.MAX_VALUE).actualValue(defaultValue).build();
    }

    @Override
    protected boolean set(Entity container, Integer value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Fire tick delay must be equal to or greater than zero!");
        return false;
    }

    @Override
    protected Optional<Integer> getVal(Entity container) {
        return Optional.of(((EntityAccessor)container).accessor$getFireImmuneTicks());
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }
}

