/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai;

import com.google.common.base.Preconditions;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ai.task.builtin.WatchClosestAITask;
import org.spongepowered.api.entity.living.Agent;

public final class SpongeWatchClosestAIBuilder
implements WatchClosestAITask.Builder {
    private Class<? extends Entity> watchedClass;
    private float maxDistance;
    private float chance;

    public SpongeWatchClosestAIBuilder() {
        this.reset();
    }

    @Override
    public WatchClosestAITask.Builder watch(Class<? extends Entity> watchedClass) {
        this.watchedClass = watchedClass;
        return this;
    }

    @Override
    public WatchClosestAITask.Builder maxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
        return this;
    }

    @Override
    public WatchClosestAITask.Builder chance(float chance) {
        this.chance = chance;
        return this;
    }

    @Override
    public WatchClosestAITask.Builder from(WatchClosestAITask value) {
        return this.watch(value.getWatchedClass()).maxDistance(value.getMaxDistance()).chance(value.getChance());
    }

    @Override
    public WatchClosestAITask.Builder reset() {
        this.watchedClass = null;
        this.maxDistance = 8.0f;
        this.chance = 0.02f;
        return this;
    }

    @Override
    public WatchClosestAITask build(Agent owner) {
        Preconditions.checkNotNull(this.watchedClass);
        return (WatchClosestAITask)new EntityAIWatchClosest((EntityLiving)owner, this.watchedClass, this.maxDistance, this.chance);
    }
}

