/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import co.aikar.timings.Timing;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.event.EventType;
import org.spongepowered.common.event.SpongeEventListener;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;

public final class RegisteredListener<T extends Event>
implements SpongeEventListener<T>,
Comparable<RegisteredListener<?>> {
    private final PluginContainer plugin;
    private final EventType<T> eventType;
    private final Order order;
    private final EventListener<? super T> listener;
    private final boolean beforeModifications;
    private Timing listenerTimer;

    RegisteredListener(PluginContainer plugin, EventType<T> eventType, Order order, EventListener<? super T> listener, boolean beforeModifications) {
        this.plugin = (PluginContainer)Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        this.eventType = (EventType)Preconditions.checkNotNull(eventType, (Object)"eventType");
        this.order = (Order)((Object)Preconditions.checkNotNull((Object)((Object)order), (Object)"order"));
        this.listener = (EventListener)Preconditions.checkNotNull(listener, (Object)"listener");
        this.beforeModifications = beforeModifications;
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }

    public EventType<T> getEventType() {
        return this.eventType;
    }

    public Order getOrder() {
        return this.order;
    }

    public boolean isBeforeModifications() {
        return this.beforeModifications;
    }

    public Timing getTimingsHandler() {
        if (this.listenerTimer == null) {
            this.listenerTimer = SpongeTimings.getPluginTimings(this.plugin, this.getHandle().getClass().getSimpleName());
        }
        return this.listenerTimer;
    }

    @Override
    public Object getHandle() {
        if (this.listener instanceof SpongeEventListener) {
            return ((SpongeEventListener)this.listener).getHandle();
        }
        return this.listener;
    }

    @Override
    public void handle(T event) throws Exception {
        this.listener.handle(event);
    }

    @Override
    public int compareTo(RegisteredListener<?> handler) {
        return this.order.compareTo(handler.order);
    }

    public static final class Cache {
        private final List<RegisteredListener<?>> listeners;
        private final EnumMap<Order, List<RegisteredListener<?>>> listenersByOrder;

        Cache(List<RegisteredListener<?>> listeners) {
            this.listeners = listeners;
            this.listenersByOrder = new EnumMap(Order.class);
            for (RegisteredListener<?> handler : listeners) {
                List list = this.listenersByOrder.computeIfAbsent(handler.getOrder(), order -> new ArrayList());
                list.add(handler);
            }
        }

        public List<RegisteredListener<?>> getListeners() {
            return this.listeners;
        }

        public List<RegisteredListener<?>> getListenersByOrder(Order order) {
            List<RegisteredListener<?>> list = this.listenersByOrder.get(Preconditions.checkNotNull((Object)((Object)order), (Object)"order"));
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }
    }
}

