/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.event.cause.EventContextKey;
import org.spongepowered.common.event.SpongeEventContextKey;
import org.spongepowered.common.registry.type.event.EventContextKeysModule;

public final class SpongeEventContextKeyBuilder<T>
implements EventContextKey.Builder<T> {
    @Nullable
    Class<T> typeClass;
    @Nullable
    String id;
    @Nullable
    String name;

    @Override
    public SpongeEventContextKeyBuilder<T> type(Class<T> aClass) {
        Preconditions.checkArgument((aClass != null ? 1 : 0) != 0, (Object)"Class cannot be null!");
        this.typeClass = aClass;
        return this;
    }

    @Override
    public SpongeEventContextKeyBuilder<T> id(String id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Id cannot be null for EventContextKey");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Cannot have an empty string id!");
        this.id = id;
        return this;
    }

    @Override
    public SpongeEventContextKeyBuilder<T> name(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null for EventContextKey");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Cannot have an empty string name!");
        this.name = name;
        return this;
    }

    @Override
    public EventContextKey<T> build() {
        Preconditions.checkState((this.typeClass != null ? 1 : 0) != 0, (Object)"Allowed type cannot be null!");
        Preconditions.checkState((this.id != null ? 1 : 0) != 0, (Object)"ID cannot be null!");
        Preconditions.checkState((!this.id.isEmpty() ? 1 : 0) != 0, (Object)"ID cannot be empty!");
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)("Name cannot be null for id: " + this.id));
        Preconditions.checkState((!this.name.isEmpty() ? 1 : 0) != 0, (Object)("Name cannot be empty for id: " + this.id));
        SpongeEventContextKey key = new SpongeEventContextKey(this);
        EventContextKeysModule.getInstance().registerAdditionalCatalog(key);
        return key;
    }

    @Override
    public SpongeEventContextKeyBuilder<T> from(EventContextKey<T> value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot create a new EventContextKey based on another key!");
    }

    @Override
    public SpongeEventContextKeyBuilder<T> reset() {
        this.typeClass = null;
        this.id = null;
        this.name = null;
        return this;
    }
}

