/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.GrowablePhaseContext;
import org.spongepowered.common.world.BlockChange;

public class GrowablePhaseState
extends PooledPhaseState<GrowablePhaseContext>
implements IPhaseState<GrowablePhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, GrowablePhaseContext> FRAME_MODIFIER = IPhaseState.super.getFrameModifier().andThen((stackFrame, growablePhaseContext) -> {
        if (!growablePhaseContext.usedItem.isEmpty()) {
            stackFrame.addContext(EventContextKeys.USED_ITEM, growablePhaseContext.usedItem);
        }
        stackFrame.addContext(EventContextKeys.GROWTH_ORIGIN, growablePhaseContext.snapshot);
    });
    private final String desc = TrackingUtil.phaseStateToString("Growable", this);

    @Override
    public GrowablePhaseContext createNewContext() {
        GrowablePhaseContext context = new GrowablePhaseContext(this);
        return (GrowablePhaseContext)context.addBlockCaptures();
    }

    @Override
    public void unwind(GrowablePhaseContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    @Override
    public boolean spawnEntityOrCapture(GrowablePhaseContext context, Entity entity, int chunkX, int chunkZ) {
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.STRUCTURE);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(GrowablePhaseContext phaseContext, IBlockState newState, Block newBlock, IBlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        return BlockChange.GROW;
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, GrowablePhaseContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    public boolean doesBulkBlockCapture(GrowablePhaseContext context) {
        return true;
    }

    @Override
    public boolean doesDenyChunkRequests() {
        return true;
    }

    @Override
    public boolean includesDecays() {
        return true;
    }

    public String toString() {
        return this.desc;
    }
}

