/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.launch.transformer.tracker;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.common.launch.transformer.tracker.MethodEntry;
import org.spongepowered.common.launch.transformer.tracker.TrackedType;
import org.spongepowered.common.launch.transformer.tracker.TrackerMethod;

public final class TrackerRegistry {
    static final Map<String, MethodEntry> methodLists = new HashMap<String, MethodEntry>();
    static final Set<String> trackerClasses = new HashSet<String>();
    private static final Map<String, TrackedType> trackedTypes = new HashMap<String, TrackedType>();
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        Launch.classLoader.addTransformerExclusion("org.spongepowered.common.launch.transformer.tracker.");
        Launch.classLoader.registerTransformer("org.spongepowered.common.launch.transformer.tracker.TrackerClassTransformer");
    }

    public static void registerKnownSubtypes(String baseType, String ... subTypes) {
        TrackerRegistry.registerKnownSubtypes(baseType, Arrays.asList(subTypes));
    }

    public static void registerKnownSubtypes(String baseType, Collection<String> subTypes) {
        TrackerRegistry.trackedTypes.computeIfAbsent((String)baseType.replace((char)'.', (char)'/'), (Function<String, TrackedType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lorg/spongepowered/common/launch/transformer/tracker/TrackedType;)()).knownSubtypes.addAll(subTypes.stream().map(e -> e.replace('.', '/')).collect(Collectors.toList()));
    }

    public static void registerTracker(String trackerClass) {
        Objects.requireNonNull(trackerClass, "trackerClass");
        trackerClasses.add(trackerClass);
        final ArrayList entries = new ArrayList();
        try {
            final String trackedMethodDesc = Type.getDescriptor(TrackerMethod.class);
            ClassReader classReader = new ClassReader(trackerClass);
            classReader.accept(new ClassVisitor(327680){

                public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
                    return new MethodVisitor(327680){

                        public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                            if (annoDesc.equals(trackedMethodDesc)) {
                                entries.add(new Entry(name, desc, access));
                            }
                            return super.visitAnnotation(desc, visible);
                        }
                    };
                }
            }, 7);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        String trackerType = trackerClass.replace('.', '/');
        for (Entry entry : entries) {
            if (!Modifier.isStatic(entry.access)) {
                throw new IllegalArgumentException("A tracker method must be static, at " + entry.name + ':' + entry.desc + " located in " + trackerClass);
            }
            if (!Modifier.isPublic(entry.access)) {
                throw new IllegalArgumentException("A tracker method must be public, at " + entry.name + ':' + entry.desc + " located in " + trackerClass);
            }
            if (entry.desc.indexOf(41) == 1) {
                throw new IllegalArgumentException("At least one parameter must be present (this is the tracked type), at " + entry.name + ':' + entry.desc + " located in " + trackerClass);
            }
            int start = entry.desc.indexOf(76);
            if (start != 1) {
                throw new IllegalArgumentException("The tracked type may not be a primitive or array, at " + entry.name + ':' + entry.desc + " located in " + trackerClass);
            }
            int end = entry.desc.indexOf(59);
            String targetType = entry.desc.substring(start + 1, end);
            TrackedType trackedType = trackedTypes.computeIfAbsent(targetType, TrackedType::new);
            String oldDesc = '(' + entry.desc.substring(end + 1);
            String id = targetType + ';' + entry.name + ';' + oldDesc;
            MethodEntry methodEntry = methodLists.computeIfAbsent(id, id1 -> new MethodEntry(Type.getArgumentTypes((String)oldDesc), Type.getReturnType((String)oldDesc)));
            if (methodEntry.entries.containsKey(trackedType)) {
                throw new IllegalArgumentException("Attempted to track a method twice, at " + entry.name + ':' + entry.desc + " located in " + trackerClass);
            }
            methodEntry.entries.put(trackedType, new MethodEntry.TargetTracker(trackerType, entry.desc));
        }
    }

    private static final class Entry {
        private final String name;
        private final String desc;
        private final int access;

        private Entry(String name, String desc, int access) {
            this.access = access;
            this.name = name;
            this.desc = desc;
        }
    }
}

