/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.gen.feature;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenFire;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.NetherFire;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={WorldGenFire.class})
public abstract class WorldGenFireMixin_API
extends WorldGenerator
implements NetherFire {
    private VariableAmount api$count = VariableAmount.fixed(10.0);
    private VariableAmount api$cluster = VariableAmount.fixed(64.0);

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.NETHER_FIRE;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        int n = this.api$count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = min.getX() + random.nextInt(size.getX());
            int z = min.getZ() + random.nextInt(size.getZ());
            int y = min.getY() + 4 + random.nextInt(120);
            this.func_180709_b(world, random, new BlockPos(x, y, z));
        }
    }

    @Override
    public VariableAmount getFirePerCluster() {
        return this.api$cluster;
    }

    @Override
    public void setFirePerCluster(VariableAmount count) {
        this.api$cluster = (VariableAmount)Preconditions.checkNotNull((Object)count);
    }

    @Override
    public VariableAmount getClustersPerChunk() {
        return this.api$count;
    }

    @Override
    public void setClustersPerChunk(VariableAmount count) {
        this.api$count = (VariableAmount)Preconditions.checkNotNull((Object)count);
    }
}

