/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.authlib;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collection;
import javax.annotation.Nullable;
import org.spongepowered.api.profile.property.ProfileProperty;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PropertyMap.class}, remap=false)
public abstract class PropertyMapMixin
implements Multimap<String, ProfileProperty> {
    @Shadow
    protected abstract Multimap<String, ProfileProperty> delegate();

    public boolean containsValue(@Nullable Object value) {
        this.sanityCheck(value);
        return this.delegate().containsValue(value);
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        this.sanityCheck(value);
        return this.delegate().containsEntry(key, value);
    }

    public boolean put(@Nullable String key, @Nullable ProfileProperty value) {
        this.sanityCheck(value);
        return this.delegate().put((Object)key, (Object)value);
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        this.sanityCheck(value);
        return this.delegate().remove(key, value);
    }

    public boolean putAll(@Nullable String key, Iterable<? extends ProfileProperty> values) {
        for (ProfileProperty profileProperty : values) {
            this.sanityCheck(profileProperty);
        }
        return this.delegate().putAll((Object)key, values);
    }

    public boolean putAll(Multimap<? extends String, ? extends ProfileProperty> multimap) {
        for (ProfileProperty property : multimap.values()) {
            this.sanityCheck(property);
        }
        return this.delegate().putAll(multimap);
    }

    public Collection<ProfileProperty> replaceValues(@Nullable String key, Iterable<? extends ProfileProperty> values) {
        for (ProfileProperty profileProperty : values) {
            this.sanityCheck(profileProperty);
        }
        return this.delegate().replaceValues((Object)key, values);
    }

    private void sanityCheck(@Nullable Object object) {
        if (object != null) {
            Preconditions.checkState((boolean)(object instanceof Property), (Object)("Property must be of type " + ProfileProperty.class.getName()));
        }
    }
}

